/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.plot.Histogram;
import smile.plot.PlotCanvas;
import smile.plot.StaircasePlot;
import smile.stat.distribution.EmpiricalDistribution;

public class EmpiricalDistributionDemo
extends JPanel {
    public EmpiricalDistributionDemo() {
        super(new GridLayout(2, 2));
        int i;
        double[] prob = new double[10];
        for (int i2 = 0; i2 < prob.length; ++i2) {
            prob[i2] = 1.0 / (double)prob.length;
        }
        EmpiricalDistribution emp = new EmpiricalDistribution(prob);
        double[] data = new double[500];
        for (int i3 = 0; i3 < 500; ++i3) {
            data[i3] = emp.rand();
        }
        PlotCanvas canvas = Histogram.plot(data, 10);
        canvas.setTitle("Equal Probabilities");
        this.add(canvas);
        double[][] p = new double[10][2];
        for (i = 0; i < p.length; ++i) {
            p[i][0] = i;
            p[i][1] = emp.p(p[i][0]);
        }
        canvas.line(p, Color.RED);
        p = new double[11][2];
        for (i = 0; i < p.length; ++i) {
            p[i][0] = i;
            p[i][1] = emp.cdf(p[i][0]);
        }
        canvas = StaircasePlot.plot(p);
        canvas.setTitle("CDF");
        this.add(canvas);
        prob = new double[10];
        for (i = 0; i < prob.length; ++i) {
            prob[i] = 1.0 / (double)prob.length;
        }
        prob[1] = 0.2;
        prob[3] = 0.05;
        prob[4] = 0.05;
        prob[6] = 0.08;
        prob[7] = 0.12;
        emp = new EmpiricalDistribution(prob);
        for (i = 0; i < 500; ++i) {
            data[i] = emp.rand();
        }
        canvas = Histogram.plot(data, 10);
        canvas.setTitle("Non-Equal Probabilities");
        this.add(canvas);
        p = new double[10][2];
        for (i = 0; i < p.length; ++i) {
            p[i][0] = i;
            p[i][1] = emp.p(p[i][0]);
        }
        canvas.line(p, Color.RED);
        p = new double[11][2];
        for (i = 0; i < p.length; ++i) {
            p[i][0] = i;
            p[i][1] = emp.cdf(p[i][0]);
        }
        canvas = StaircasePlot.plot(p);
        canvas.setTitle("CDF");
        this.add(canvas);
    }

    @Override
    public String toString() {
        return "Empirical";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Empirical Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new EmpiricalDistributionDemo());
        frame.setVisible(true);
    }
}

