/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.projection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import smile.classification.FLD;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.plot.Palette;
import smile.plot.PlotCanvas;

public class LDADemo
extends JPanel
implements Runnable,
ActionListener {
    private static final String[] datasetName = new String[]{"IRIS", "Pen Digits"};
    private static final String[] datasource = new String[]{"classification/iris.txt", "pendigits.txt"};
    static AttributeDataset[] dataset = new AttributeDataset[datasetName.length];
    static int datasetIndex = 0;
    JPanel optionPane;
    JComponent canvas;
    private JButton startButton;
    private JComboBox<String> datasetBox;
    char pointLegend = (char)46;

    public LDADemo() {
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        this.datasetBox = new JComboBox();
        for (int i = 0; i < datasetName.length; ++i) {
            this.datasetBox.addItem(datasetName[i]);
        }
        this.datasetBox.setSelectedIndex(0);
        this.datasetBox.setActionCommand("datasetBox");
        this.datasetBox.addActionListener(this);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("Dataset:"));
        this.optionPane.add(this.datasetBox);
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionPane, "North");
    }

    public JComponent learn() {
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        String[] names = dataset[datasetIndex].toArray(new String[dataset[datasetIndex].size()]);
        if (names[0] == null) {
            names = null;
        }
        int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
        int min = Math.min(label);
        int i = 0;
        while (i < label.length) {
            int n = i++;
            label[n] = label[n] - min;
        }
        long clock = System.currentTimeMillis();
        FLD lda = new FLD(data, label, Math.unique(label).length > 3 ? 3 : 2);
        System.out.format("Learn LDA from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        double[][] y = lda.project(data);
        PlotCanvas plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            int[] labels = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (int i2 = 0; i2 < y.length; ++i2) {
                plot.point(this.pointLegend, Palette.COLORS[labels[i2]], y[i2]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("Linear Discriminant Analysis");
        return plot;
    }

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.datasetBox.setEnabled(false);
        JComponent plot = this.learn();
        if (plot != null) {
            if (this.canvas != null) {
                this.remove(this.canvas);
            }
            this.canvas = plot;
            this.add((Component)plot, "Center");
        }
        this.validate();
        this.startButton.setEnabled(true);
        this.datasetBox.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            datasetIndex = this.datasetBox.getSelectedIndex();
            if (dataset[datasetIndex] == null) {
                DelimitedTextParser parser = new DelimitedTextParser();
                parser.setDelimiter("[\t]+");
                if (datasetIndex == 0) {
                    parser.setColumnNames(true);
                }
                if (datasetIndex == 0) {
                    parser.setResponseIndex(new NominalAttribute("class"), 4);
                }
                if (datasetIndex == 1) {
                    parser.setResponseIndex(new NominalAttribute("class"), 16);
                }
                try {
                    LDADemo.dataset[LDADemo.datasetIndex] = parser.parse(datasetName[datasetIndex], IOUtils.getTestDataFile(datasource[datasetIndex]));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                    System.out.println(ex);
                }
            }
            this.pointLegend = dataset[datasetIndex].size() < 500 ? (char)111 : (char)46;
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public String toString() {
        return "Linear Discriminant Analysis";
    }
}

