/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.plot;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.math.Math;
import smile.plot.Histogram;
import smile.plot.PlotCanvas;

public class HistogramDemo
extends JPanel {
    public HistogramDemo() {
        super(new GridLayout(1, 2));
        double[] data = new double[1000];
        for (int j = 0; j < data.length; ++j) {
            double y;
            double x;
            double r;
            while ((r = (x = 2.0 * (Math.random() - 0.5)) * x + (y = 2.0 * (Math.random() - 0.5)) * y) >= 1.0) {
            }
            double z = Math.sqrt(-2.0 * Math.log(r) / r);
            data[j] = 0.01 * x * z;
        }
        PlotCanvas canvas = Histogram.plot("Dataset 1", data, smile.math.Histogram.breaks(-0.06, 0.06, 30));
        canvas.setTitle("Overlapped Histogram");
        this.add(canvas);
        data = new double[1000];
        for (int j = 0; j < data.length; ++j) {
            double y;
            double x;
            double r;
            while ((r = (x = 2.0 * (Math.random() - 0.5)) * x + (y = 2.0 * (Math.random() - 0.5)) * y) >= 1.0) {
            }
            double z = Math.sqrt(-2.0 * Math.log(r) / r);
            data[j] = 0.01 * (2.0 + x * z);
        }
        canvas.histogram("Dataset 2", data, smile.math.Histogram.breaks(-0.06, 0.06, 30), Color.RED);
        double[] prob = new double[]{0.2, 0.3, 0.1, 0.05, 0.2, 0.15};
        int[] data2 = Math.random(prob, 1000);
        canvas = Histogram.plot(data2, 6);
        canvas.setTitle("Sampling with Uneuqal Probabilities");
        this.add(canvas);
    }

    @Override
    public String toString() {
        return "Histogram";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Histogram");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new HistogramDemo());
        frame.setVisible(true);
    }
}

