/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.plot;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.plot.Contour;
import smile.plot.Palette;

public class ContourDemo
extends JPanel {
    public ContourDemo() {
        super(new GridLayout(1, 2));
        this.setBackground(Color.white);
        int n = 41;
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = -2.0 + 0.1 * (double)i;
        }
        int m = 51;
        double[] y = new double[m];
        for (int i = 0; i < m; ++i) {
            y[i] = -2.0 + 0.1 * (double)i;
        }
        double[][] z = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j] = x[j] * Math.exp(-x[j] * x[j] - y[i] * y[i]);
            }
        }
        this.add(Contour.plot(x, y, z));
        double[] c = new double[9];
        for (int i = 0; i < c.length; ++i) {
            c[i] = -0.4 + 0.1 * (double)i;
        }
        this.add(Contour.plot(x, y, z, c, Palette.jet(c.length)));
    }

    @Override
    public String toString() {
        return "Contour";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Contour");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new ContourDemo());
        frame.setVisible(true);
    }
}

