/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.mds;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.mds.SammonMapping;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class SammonMappingDemo
extends JPanel
implements Runnable,
ActionListener {
    private static final String[] datasetName = new String[]{"British Towns", "Euro Cities", "Morse Code", "Color Stimuli", "Lloyds Bank Employees 1905-1909", "Lloyds Bank Employees 1925-1929"};
    private static final String[] datasource = new String[]{"projection/BritishTowns.txt", "projection/eurodist.txt", "projection/morsecode.txt", "projection/colorstimuli.txt", "projection/bank05d.txt", "projection/bank25d.txt"};
    static AttributeDataset[] dataset = new AttributeDataset[datasetName.length];
    static int datasetIndex = 0;
    JPanel optionPane;
    JComponent canvas;
    private JButton startButton = new JButton("Start");
    private JComboBox<String> datasetBox;

    public SammonMappingDemo() {
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        this.datasetBox = new JComboBox();
        for (int i = 0; i < datasetName.length; ++i) {
            this.datasetBox.addItem(datasetName[i]);
        }
        this.datasetBox.setSelectedIndex(0);
        this.datasetBox.setActionCommand("datasetBox");
        this.datasetBox.addActionListener(this);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("Dataset:"));
        this.optionPane.add(this.datasetBox);
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionPane, "North");
    }

    public JComponent learn() {
        JPanel pane = new JPanel(new GridLayout(1, 2));
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        String[] labels = dataset[datasetIndex].toArray(new String[dataset[datasetIndex].size()]);
        if (labels[0] == null) {
            Attribute[] attr = dataset[datasetIndex].attributes();
            labels = new String[attr.length];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = attr[i].getName();
            }
        }
        long clock = System.currentTimeMillis();
        SammonMapping sammon = new SammonMapping(data, 2);
        System.out.format("Learn Sammon's Mapping (k=2) from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot(sammon.getCoordinates(), labels);
        plot.setTitle("Sammon's Mapping (k = 2)");
        pane.add(plot);
        clock = System.currentTimeMillis();
        sammon = new SammonMapping(data, 3);
        System.out.format("Learn Sammon's Mapping (k=3) from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        plot = ScatterPlot.plot(sammon.getCoordinates(), labels);
        plot.setTitle("Sammon's Mapping (k = 3)");
        pane.add(plot);
        return pane;
    }

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.datasetBox.setEnabled(false);
        try {
            JComponent plot = this.learn();
            if (plot != null) {
                if (this.canvas != null) {
                    this.remove(this.canvas);
                }
                this.canvas = plot;
                this.add((Component)plot, "Center");
            }
            this.validate();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        this.startButton.setEnabled(true);
        this.datasetBox.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            datasetIndex = this.datasetBox.getSelectedIndex();
            if (dataset[datasetIndex] == null) {
                DelimitedTextParser parser = new DelimitedTextParser();
                parser.setDelimiter("[\t]+");
                parser.setRowNames(true);
                parser.setColumnNames(true);
                if (datasetIndex == 2 || datasetIndex == 3) {
                    parser.setRowNames(false);
                }
                try {
                    SammonMappingDemo.dataset[SammonMappingDemo.datasetIndex] = parser.parse(datasetName[datasetIndex], IOUtils.getTestDataFile(datasource[datasetIndex]));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                    System.err.println(ex);
                }
            }
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public String toString() {
        return "Sammon's Mapping";
    }

    public static void main(String[] argv) {
        SammonMappingDemo demo = new SammonMappingDemo();
        JFrame f = new JFrame("Sammon's Mapping");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

