/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.manifold;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smile.demo.manifold.ManifoldDemo;
import smile.graph.Graph;
import smile.manifold.LaplacianEigenmap;
import smile.math.Math;
import smile.plot.PlotCanvas;

public class LaplacianEigenmapDemo
extends ManifoldDemo {
    private double sigma = -1.0;
    private JTextField sigmaField = new JTextField(Double.toString(this.sigma), 5);

    public LaplacianEigenmapDemo() {
        this.optionPane.add(new JLabel("t:"));
        this.optionPane.add(this.sigmaField);
    }

    @Override
    public JComponent learn() {
        JPanel pane = new JPanel(new GridLayout(1, 2));
        try {
            this.sigma = Double.parseDouble(this.sigmaField.getText().trim());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid t: " + this.sigmaField.getText(), "Error", 0);
            return pane;
        }
        this.sigmaField.setEnabled(false);
        Object data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        if (((double[][])data).length > 1000) {
            double[][] x = new double[1000][];
            for (int i = 0; i < 1000; ++i) {
                x[i] = data[i];
            }
            data = x;
        }
        long clock = System.currentTimeMillis();
        LaplacianEigenmap eigenmap = new LaplacianEigenmap((double[][])data, 2, this.k, this.sigma);
        System.out.format("Learn Laplacian Eigenmap from %d samples in %dms\n", ((double[][])data).length, System.currentTimeMillis() - clock);
        double[][] y = eigenmap.getCoordinates();
        PlotCanvas plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        plot.points(y, 'o', Color.RED);
        int n = y.length;
        Graph graph = eigenmap.getNearestNeighborGraph();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!graph.hasEdge(i, j)) continue;
                plot.line((double[][])new double[][]{y[i], y[j]});
            }
        }
        plot.setTitle("Laplacian Eigenmap");
        pane.add(plot);
        this.sigmaField.setEnabled(true);
        return pane;
    }

    @Override
    public String toString() {
        return "Laplacian Eigenmap";
    }

    public static void main(String[] argv) {
        LaplacianEigenmapDemo demo = new LaplacianEigenmapDemo();
        JFrame f = new JFrame("Laplacian Eigenmap");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

