/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.manifold;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.demo.manifold.ManifoldDemo;
import smile.graph.Graph;
import smile.manifold.IsoMap;
import smile.math.Math;
import smile.plot.PlotCanvas;

public class IsoMapDemo
extends ManifoldDemo {
    @Override
    public JComponent learn() {
        JPanel pane = new JPanel(new GridLayout(1, 2));
        Object data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        if (((double[][])data).length > 1000) {
            double[][] x = new double[1000][];
            for (int i = 0; i < 1000; ++i) {
                x[i] = data[i];
            }
            data = x;
        }
        long clock = System.currentTimeMillis();
        IsoMap isomap = new IsoMap((double[][])data, 2, this.k);
        System.out.format("Learn IsoMap from %d samples in %dms\n", ((double[][])data).length, System.currentTimeMillis() - clock);
        double[][] y = isomap.getCoordinates();
        PlotCanvas plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        plot.points(y, 'o', Color.RED);
        int n = y.length;
        Graph graph = isomap.getNearestNeighborGraph();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!graph.hasEdge(i, j)) continue;
                plot.line((double[][])new double[][]{y[i], y[j]});
            }
        }
        plot.setTitle("IsoMap");
        pane.add(plot);
        return pane;
    }

    @Override
    public String toString() {
        return "IsoMap";
    }

    public static void main(String[] argv) {
        IsoMapDemo demo = new IsoMapDemo();
        JFrame f = new JFrame("IsoMap");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

