/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.clustering.XMeans;
import smile.demo.clustering.ClusteringDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class XMeansDemo
extends ClusteringDemo {
    JTextField maxClusterNumberField;
    int maxClusterNumber = 50;

    public XMeansDemo() {
        this.optionPane.remove(this.optionPane.getComponentCount() - 1);
        this.optionPane.remove(this.optionPane.getComponentCount() - 1);
        this.maxClusterNumberField = new JTextField(Integer.toString(this.maxClusterNumber), 5);
        this.optionPane.add(new JLabel("Max K:"));
        this.optionPane.add(this.maxClusterNumberField);
    }

    @Override
    public JComponent learn() {
        try {
            this.maxClusterNumber = Integer.parseInt(this.maxClusterNumberField.getText().trim());
            if (this.maxClusterNumber < 2) {
                JOptionPane.showMessageDialog(this, "Invalid Max K: " + this.maxClusterNumber, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid Max K: " + this.maxClusterNumberField.getText(), "Error", 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        XMeans xmeans = new XMeans(dataset[datasetIndex], this.maxClusterNumber);
        System.out.format("X-Means clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot(xmeans.centroids(), '@');
        for (int k = 0; k < xmeans.getNumClusters(); ++k) {
            if (xmeans.getClusterSize()[k] <= 0) continue;
            double[][] cluster = new double[xmeans.getClusterSize()[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (xmeans.getClusterLabel()[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        plot.points(xmeans.centroids(), '@');
        return plot;
    }

    @Override
    public String toString() {
        return "X-Means";
    }

    public static void main(String[] argv) {
        XMeansDemo demo = new XMeansDemo();
        JFrame f = new JFrame("X-Means");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

