/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import smile.clustering.SIB;
import smile.data.SparseDataset;
import smile.data.parser.IOUtils;
import smile.data.parser.SparseDatasetParser;
import smile.math.SparseArray;

public class SIBDemo
extends JPanel
implements Runnable,
ActionListener {
    private JPanel optionPane;
    private JTextArea outputArea;
    private JButton startButton;
    private JComboBox<String> datasetBox;
    private JTextField clusterNumberField;
    private int datasetIndex = 0;
    private int clusterNumber = 5;
    private String[] datasetName = new String[]{"NIPS", "KOS", "Enron"};
    private String[] datasource = new String[]{"text/nips.txt", "text/kos.txt", "text/enron.txt"};
    private SparseDataset[] dataset = new SparseDataset[this.datasetName.length];

    public SIBDemo() {
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        this.datasetBox = new JComboBox();
        for (int i = 0; i < this.datasetName.length; ++i) {
            this.datasetBox.addItem(this.datasetName[i]);
        }
        this.datasetBox.setSelectedIndex(0);
        this.datasetBox.setActionCommand("datasetBox");
        this.datasetBox.addActionListener(this);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("Dataset:"));
        this.optionPane.add(this.datasetBox);
        this.clusterNumberField = new JTextField(Integer.toString(this.clusterNumber), 5);
        this.optionPane.add(new JLabel("K:"));
        this.optionPane.add(this.clusterNumberField);
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionPane, "North");
        this.outputArea = new JTextArea();
        this.outputArea.setEditable(false);
        JScrollPane outputView = new JScrollPane(this.outputArea);
        this.add((Component)outputView, "Center");
    }

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.datasetBox.setEnabled(false);
        this.clustering();
        this.startButton.setEnabled(true);
        this.datasetBox.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            Thread thread = new Thread(this);
            thread.start();
        } else if ("datasetBox".equals(e.getActionCommand())) {
            this.datasetIndex = this.datasetBox.getSelectedIndex();
        }
    }

    private void clustering() {
        try {
            this.clusterNumber = Integer.parseInt(this.clusterNumberField.getText().trim());
            if (this.clusterNumber < 2) {
                JOptionPane.showMessageDialog(this, "Invalid K: " + this.clusterNumber, "Error", 0);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid K: " + this.clusterNumberField.getText(), "Error", 0);
        }
        if (this.dataset[this.datasetIndex] == null) {
            try {
                SparseDatasetParser parser = new SparseDatasetParser(1);
                this.dataset[this.datasetIndex] = parser.parse(this.datasetName[this.datasetIndex], IOUtils.getTestDataFile(this.datasource[this.datasetIndex]));
                int i = this.dataset[this.datasetIndex].size();
                while (i-- > 0) {
                    if (!((SparseArray)this.dataset[this.datasetIndex].get((int)i).x).isEmpty()) continue;
                    this.dataset[this.datasetIndex].remove(i);
                }
                this.dataset[this.datasetIndex].unitize1();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                System.err.println(ex);
            }
        }
        System.out.println("The dataset " + this.datasetName[this.datasetIndex] + " has " + this.dataset[this.datasetIndex].size() + " documents and " + this.dataset[this.datasetIndex].ncols() + " words.");
        long clock = System.currentTimeMillis();
        SIB sib = new SIB(this.dataset[this.datasetIndex], this.clusterNumber, 20);
        this.outputArea.setText("");
        for (int j = 0; j < this.dataset[this.datasetIndex].ncols(); ++j) {
            for (int i = 0; i < this.clusterNumber; ++i) {
                this.outputArea.append(String.format("%.5f\t", sib.centroids()[i][j]));
            }
            this.outputArea.append("\n");
        }
        System.out.format("SIB clusterings %d samples in %dms\n", this.dataset[this.datasetIndex].size(), System.currentTimeMillis() - clock);
    }

    @Override
    public String toString() {
        return "Sequential Information Bottleneck";
    }

    public static void main(String[] argv) {
        SIBDemo demo = new SIBDemo();
        JFrame f = new JFrame("SIB");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

