/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smile.clustering.DBScan;
import smile.demo.clustering.ClusteringDemo;
import smile.math.distance.EuclideanDistance;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class DBScanDemo
extends ClusteringDemo {
    JTextField minPtsField;
    JTextField rangeField;
    int minPts = 10;
    double range = 10.0;

    public DBScanDemo() {
        this.optionPane.remove(this.optionPane.getComponentCount() - 1);
        this.optionPane.remove(this.optionPane.getComponentCount() - 1);
        this.minPtsField = new JTextField(Integer.toString(this.minPts), 5);
        this.optionPane.add(new JLabel("MinPts:"));
        this.optionPane.add(this.minPtsField);
        this.rangeField = new JTextField(Double.toString(this.range), 5);
        this.optionPane.add(new JLabel("Range:"));
        this.optionPane.add(this.rangeField);
    }

    @Override
    public JComponent learn() {
        try {
            this.minPts = Integer.parseInt(this.minPtsField.getText().trim());
            if (this.minPts < 1) {
                JOptionPane.showMessageDialog(this, "Invalid MinPts: " + this.minPts, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid MinPts: " + this.minPtsField.getText(), "Error", 0);
            return null;
        }
        try {
            this.range = Double.parseDouble(this.rangeField.getText().trim());
            if (this.range <= 0.0) {
                JOptionPane.showMessageDialog(this, "Invalid Range: " + this.range, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid range: " + this.rangeField.getText(), "Error", 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        DBScan<double[]> dbscan = new DBScan<double[]>((T[])dataset[datasetIndex], new EuclideanDistance(), this.minPts, this.range);
        System.out.format("DBSCAN clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        JPanel pane = new JPanel(new GridLayout(1, 2));
        PlotCanvas plot = ScatterPlot.plot(dataset[datasetIndex], this.pointLegend);
        for (int k = 0; k < dbscan.getNumClusters(); ++k) {
            double[][] cluster = new double[dbscan.getClusterSize()[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (dbscan.getClusterLabel()[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        pane.add(plot);
        return pane;
    }

    @Override
    public String toString() {
        return "DBScan";
    }

    public static void main(String[] argv) {
        DBScanDemo demo = new DBScanDemo();
        JFrame f = new JFrame("DBScan");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

