/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import smile.data.AttributeDataset;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.plot.ScatterPlot;

public abstract class ClusteringDemo
extends JPanel
implements Runnable,
ActionListener,
AncestorListener {
    private static final String ERROR = "Error";
    private static String[] datasetName = new String[]{"Gaussian/One", "Gaussian/Two", "Gaussian/Three", "Gaussian/Five", "Gaussian/Six", "Gaussian/Elongate", "NonConvex/Cross", "NonConvex/D4", "NonConvex/Face", "NonConvex/Pie", "NonConvex/Ring", "NonConvex/Sincos", "Chameleon/t4.8k", "Chameleon/t5.8k", "Chameleon/t7.10k", "Chameleon/t8.8k"};
    private static String[] datasource = new String[]{"clustering/gaussian/one.txt", "clustering/gaussian/two.txt", "clustering/gaussian/three.txt", "clustering/gaussian/five.txt", "clustering/gaussian/six.txt", "clustering/gaussian/elongate.txt", "clustering/nonconvex/cross.txt", "clustering/nonconvex/d4.txt", "clustering/nonconvex/face.txt", "clustering/nonconvex/pie.txt", "clustering/nonconvex/ring.txt", "clustering/nonconvex/sincos.txt", "clustering/chameleon/t4.8k.txt", "clustering/chameleon/t5.8k.txt", "clustering/chameleon/t7.10k.txt", "clustering/chameleon/t8.8k.txt"};
    static double[][][] dataset = null;
    static int datasetIndex = 0;
    static int clusterNumber = 2;
    JPanel optionPane;
    JComponent canvas;
    private JTextField clusterNumberField;
    private JButton startButton;
    private JComboBox<String> datasetBox;
    char pointLegend = (char)46;

    public ClusteringDemo() {
        if (dataset == null) {
            dataset = new double[datasetName.length][][];
            DelimitedTextParser parser = new DelimitedTextParser();
            parser.setDelimiter("[\t ]+");
            try {
                AttributeDataset data = parser.parse(datasetName[datasetIndex], IOUtils.getTestDataFile(datasource[datasetIndex]));
                ClusteringDemo.dataset[ClusteringDemo.datasetIndex] = (double[][])data.toArray((E[])new double[data.size()][]);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                System.err.println(e);
            }
        }
        this.addAncestorListener(this);
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        this.datasetBox = new JComboBox();
        for (int i = 0; i < datasetName.length; ++i) {
            this.datasetBox.addItem(datasetName[i]);
        }
        this.datasetBox.setSelectedIndex(0);
        this.datasetBox.setActionCommand("datasetBox");
        this.datasetBox.addActionListener(this);
        this.clusterNumberField = new JTextField(Integer.toString(clusterNumber), 5);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("Dataset:"));
        this.optionPane.add(this.datasetBox);
        this.optionPane.add(new JLabel("K:"));
        this.optionPane.add(this.clusterNumberField);
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionPane, "North");
        this.canvas = ScatterPlot.plot(dataset[datasetIndex], '.');
        this.add((Component)this.canvas, "Center");
    }

    public abstract JComponent learn();

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.datasetBox.setEnabled(false);
        try {
            JComponent plot = this.learn();
            if (plot != null) {
                this.remove(this.canvas);
                this.canvas = plot;
                this.add((Component)this.canvas, "Center");
            }
            this.validate();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        this.startButton.setEnabled(true);
        this.datasetBox.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            try {
                clusterNumber = Integer.parseInt(this.clusterNumberField.getText().trim());
                if (clusterNumber < 2) {
                    JOptionPane.showMessageDialog(this, "Invalid K: " + clusterNumber, ERROR, 0);
                    return;
                }
                if (clusterNumber > dataset[datasetIndex].length / 2) {
                    JOptionPane.showMessageDialog(this, "Too large K: " + clusterNumber, ERROR, 0);
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid K: " + this.clusterNumberField.getText(), ERROR, 0);
                return;
            }
            Thread thread = new Thread(this);
            thread.start();
        } else if ("datasetBox".equals(e.getActionCommand())) {
            datasetIndex = this.datasetBox.getSelectedIndex();
            if (dataset[datasetIndex] == null) {
                DelimitedTextParser parser = new DelimitedTextParser();
                parser.setDelimiter("[\t ]+");
                try {
                    AttributeDataset data = parser.parse(datasetName[datasetIndex], IOUtils.getTestDataFile(datasource[datasetIndex]));
                    ClusteringDemo.dataset[ClusteringDemo.datasetIndex] = (double[][])data.toArray((E[])new double[data.size()][]);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                    System.err.println(ex);
                }
            }
            this.remove(this.canvas);
            this.pointLegend = dataset[datasetIndex].length < 500 ? (char)111 : (char)46;
            this.canvas = ScatterPlot.plot(dataset[datasetIndex], this.pointLegend);
            this.add((Component)this.canvas, "Center");
            this.validate();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.clusterNumberField.setText(Integer.toString(clusterNumber));
        if (this.datasetBox.getSelectedIndex() != datasetIndex) {
            this.datasetBox.setSelectedIndex(datasetIndex);
            this.remove(this.canvas);
            this.pointLegend = dataset[datasetIndex].length < 500 ? (char)111 : (char)46;
            this.canvas = ScatterPlot.plot(dataset[datasetIndex], this.pointLegend);
            this.add((Component)this.canvas, "Center");
            this.validate();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }
}

