/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.classification;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.classification.LogisticRegression;
import smile.demo.classification.ClassificationDemo;

public class LogisticRegressionDemo
extends ClassificationDemo {
    private double lambda = 0.1;
    private JTextField lambdaField = new JTextField(Double.toString(this.lambda), 5);

    public LogisticRegressionDemo() {
        this.optionPane.add(new JLabel("\u03bb:"));
        this.optionPane.add(this.lambdaField);
    }

    @Override
    public double[][] learn(double[] x, double[] y) {
        try {
            this.lambda = Double.parseDouble(this.lambdaField.getText().trim());
            if (this.lambda < 0.0) {
                JOptionPane.showMessageDialog(this, "Invalid \u03bb: " + this.lambda, "Error", 0);
                return null;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid \u03bb: " + this.lambdaField.getText(), "Error", 0);
            return null;
        }
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
        LogisticRegression logit = new LogisticRegression(data, label, this.lambda);
        for (int i = 0; i < label.length; ++i) {
            label[i] = logit.predict(data[i]);
        }
        double trainError = this.error(label, label);
        System.out.format("training error = %.2f%%\n", 100.0 * trainError);
        double[][] z = new double[y.length][x.length];
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                double[] p = new double[]{x[j], y[i]};
                z[i][j] = logit.predict(p);
            }
        }
        return z;
    }

    @Override
    public String toString() {
        return "Logistic Regression";
    }

    public static void main(String[] argv) {
        LogisticRegressionDemo demo = new LogisticRegressionDemo();
        JFrame f = new JFrame("Logistic Regression");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

