/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import smile.data.Attribute;
import smile.data.AttributeVector;
import smile.data.Datum;

public class Dataset<E>
implements Iterable<Datum<E>> {
    protected static final String DATASET_HAS_NO_RESPONSE = "The dataset has no response values.";
    protected static final String RESPONSE_NOT_NOMINAL = "The response variable is not nominal.";
    protected static final String RESPONSE_NOT_NUMERIC = "The response variable is not numeric.";
    protected String name;
    protected String description = "";
    protected Attribute response = null;
    protected List<Datum<E>> data = new ArrayList<Datum<E>>();

    public Dataset() {
        this("Dataset");
    }

    public Dataset(String name) {
        this.name = name;
    }

    public Dataset(Attribute response) {
        this("Dataset", response);
    }

    public Dataset(String name, Attribute response) {
        this.name = name;
        this.response = response;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Attribute responseAttribute() {
        return this.response;
    }

    public AttributeVector response() {
        double[] y = new double[this.data.size()];
        for (int i = 0; i < y.length; ++i) {
            y[i] = this.data.get((int)i).y;
        }
        return new AttributeVector(this.response, y);
    }

    public int size() {
        return this.data.size();
    }

    public List<Datum<E>> data() {
        return this.data;
    }

    public Datum<E> add(Datum<E> x) {
        this.data.add(x);
        return x;
    }

    public Datum<E> add(E x) {
        return this.add((E)new Datum<E>(x));
    }

    public Datum<E> add(E x, int y) {
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException(RESPONSE_NOT_NOMINAL);
        }
        return this.add((E)new Datum<E>(x, y));
    }

    public Datum<E> add(E x, int y, double weight) {
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException(RESPONSE_NOT_NOMINAL);
        }
        return this.add((E)new Datum<E>(x, y, weight));
    }

    public Datum<E> add(E x, double y) {
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException(RESPONSE_NOT_NUMERIC);
        }
        return this.add((E)new Datum<E>(x, y));
    }

    public Datum<E> add(E x, double y, double weight) {
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException(RESPONSE_NOT_NUMERIC);
        }
        return this.add((E)new Datum<E>(x, y, weight));
    }

    public Datum<E> remove(int i) {
        return this.data.remove(i);
    }

    public Datum<E> get(int i) {
        return this.data.get(i);
    }

    @Override
    public Iterator<Datum<E>> iterator() {
        return new Iterator<Datum<E>>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Dataset.this.data.size();
            }

            @Override
            public Datum<E> next() {
                return Dataset.this.get(this.i++);
            }

            @Override
            public void remove() {
                Dataset.this.remove(this.i);
            }
        };
    }

    public double[] y() {
        double[] y = new double[this.size()];
        this.toArray(y);
        return y;
    }

    public int[] labels() {
        int[] y = new int[this.size()];
        this.toArray(y);
        return y;
    }

    public E[] toArray(E[] a) {
        int i;
        int n = this.data.size();
        if (a.length < n) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), n);
        }
        for (i = 0; i < n; ++i) {
            a[i] = this.get((int)i).x;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = null;
        }
        return a;
    }

    public int[] toArray(int[] a) {
        int i;
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException(RESPONSE_NOT_NOMINAL);
        }
        int n = this.data.size();
        if (a.length < n) {
            a = new int[n];
        }
        for (i = 0; i < n; ++i) {
            Datum<E> datum = this.get(i);
            a[i] = Double.isNaN(datum.y) ? Integer.MIN_VALUE : (int)this.get((int)i).y;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = Integer.MIN_VALUE;
        }
        return a;
    }

    public double[] toArray(double[] a) {
        int i;
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException(RESPONSE_NOT_NUMERIC);
        }
        int n = this.data.size();
        if (a.length < n) {
            a = new double[n];
        }
        for (i = 0; i < n; ++i) {
            a[i] = this.get((int)i).y;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = Double.NaN;
        }
        return a;
    }

    public String[] toArray(String[] a) {
        int i;
        int n = this.data.size();
        if (a.length < n) {
            a = new String[n];
        }
        for (i = 0; i < n; ++i) {
            a[i] = this.data.get((int)i).name;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = null;
        }
        return a;
    }

    public Timestamp[] toArray(Timestamp[] a) {
        int i;
        int n = this.data.size();
        if (a.length < n) {
            a = new Timestamp[n];
        }
        for (i = 0; i < n; ++i) {
            a[i] = this.data.get((int)i).timestamp;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = null;
        }
        return a;
    }
}

