/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import smile.clustering.CLARANS;
import smile.clustering.KMeans;
import smile.clustering.PartitionClustering;
import smile.math.Math;
import smile.math.distance.Distance;
import smile.math.distance.EuclideanDistance;
import smile.math.distance.Metric;
import smile.neighbor.CoverTree;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;
import smile.util.MulticoreExecutor;

public class MEC<T>
extends PartitionClustering<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double radius;
    private double entropy;
    private RNNSearch<T, T> nns;

    public MEC(T[] data, Distance<T> distance, int k, double radius) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        LinearSearch<T> naive = new LinearSearch<T>(data, distance);
        naive.setIdenticalExcluded(false);
        if (data[0] instanceof double[] && distance instanceof EuclideanDistance) {
            KMeans kmeans = new KMeans((double[][])data, k, 10, Math.max(1, MulticoreExecutor.getThreadPoolSize()));
            this.y = kmeans.getClusterLabel();
        } else {
            CLARANS<T> clarans = new CLARANS<T>(data, distance, k, Math.min(100, (int)Math.round(0.01 * (double)k * (double)(data.length - k))), Math.max(1, MulticoreExecutor.getThreadPoolSize()));
            this.y = clarans.getClusterLabel();
        }
        this.learn(data, naive, k, radius, this.y);
    }

    public MEC(T[] data, Metric<T> distance, int k, double radius) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        CoverTree<T> cover = new CoverTree<T>(data, distance);
        cover.setIdenticalExcluded(false);
        if (data[0] instanceof double[] && distance instanceof EuclideanDistance) {
            KMeans kmeans = new KMeans((double[][])data, k, 10, Math.max(1, MulticoreExecutor.getThreadPoolSize()));
            this.y = kmeans.getClusterLabel();
        } else {
            CLARANS<T> clarans = new CLARANS<T>(data, distance, k, Math.min(100, (int)Math.round(0.01 * (double)k * (double)(data.length - k))), Math.max(1, MulticoreExecutor.getThreadPoolSize()));
            this.y = clarans.getClusterLabel();
        }
        this.learn(data, cover, k, radius, this.y);
    }

    public MEC(T[] data, RNNSearch<T, T> nns, int k, double radius, int[] y) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        this.learn(data, nns, k, radius, (int[])y.clone());
    }

    /*
     * WARNING - void declaration
     */
    private void learn(T[] data, RNNSearch<T, T> nns, int k, double radius, int[] y) {
        void var14_27;
        int i;
        int i2;
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        this.k = k;
        this.nns = nns;
        this.radius = radius;
        this.y = y;
        this.size = new int[k];
        int n = data.length;
        for (int i3 = 0; i3 < n; ++i3) {
            int n2 = y[i3];
            this.size[n2] = this.size[n2] + 1;
        }
        double[] px = new double[n];
        ArrayList neighbors = new ArrayList();
        for (int i4 = 0; i4 < n; ++i4) {
            ArrayList list = new ArrayList();
            nns.range(data[i4], radius, list);
            ArrayList<Integer> neighbor = new ArrayList<Integer>(list.size());
            neighbors.add(neighbor);
            for (Neighbor neighbor2 : list) {
                neighbor.add(neighbor2.index);
            }
            px[i4] = (double)list.size() / (double)n;
        }
        int[][] neighborhoodClusterSize = new int[n][k];
        int[] mostSignificantNeighborhoodCluster = new int[n];
        for (int i22 = 0; i22 < n; ++i22) {
            Iterator<Object> iterator = ((ArrayList)neighbors.get(i22)).iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                int[] nArray = neighborhoodClusterSize[i22];
                int n4 = y[n3];
                nArray[n4] = nArray[n4] + 1;
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            int max = 0;
            for (int j = 0; j < k; ++j) {
                if (neighborhoodClusterSize[i2][j] <= max) continue;
                mostSignificantNeighborhoodCluster[i2] = j;
                max = neighborhoodClusterSize[i2][j];
            }
        }
        this.entropy = 0.0;
        for (i2 = 0; i2 < n; ++i2) {
            if (((ArrayList)neighbors.get(i2)).isEmpty()) continue;
            int ni = ((ArrayList)neighbors.get(i2)).size();
            double d = 0.0;
            for (int j = 0; j < k; ++j) {
                double r = (double)neighborhoodClusterSize[i2][j] / (double)ni;
                if (!(r > 0.0)) continue;
                d -= r * Math.log2(r);
            }
            this.entropy += (d *= px[i2]);
        }
        double eps = 1.0;
        while (eps >= 1.0E-7) {
            void var14_24;
            boolean bl = false;
            while (var14_24 < n) {
                if (mostSignificantNeighborhoodCluster[var14_24] != y[var14_24]) {
                    int neighbor;
                    double oldMutual = 0.0;
                    double newMutual = 0.0;
                    Iterator iterator = ((ArrayList)neighbors.get((int)var14_24)).iterator();
                    while (iterator.hasNext()) {
                        neighbor = (Integer)iterator.next();
                        double nk = ((ArrayList)neighbors.get(neighbor)).size();
                        double r1 = (double)neighborhoodClusterSize[neighbor][y[var14_24]] / nk;
                        double r2 = (double)neighborhoodClusterSize[neighbor][mostSignificantNeighborhoodCluster[var14_24]] / nk;
                        if (r1 > 0.0) {
                            oldMutual -= r1 * Math.log2(r1) * px[neighbor];
                        }
                        if (r2 > 0.0) {
                            oldMutual -= r2 * Math.log2(r2) * px[neighbor];
                        }
                        r1 = ((double)neighborhoodClusterSize[neighbor][y[var14_24]] - 1.0) / nk;
                        r2 = ((double)neighborhoodClusterSize[neighbor][mostSignificantNeighborhoodCluster[var14_24]] + 1.0) / nk;
                        if (r1 > 0.0) {
                            newMutual -= r1 * Math.log2(r1) * px[neighbor];
                        }
                        if (!(r2 > 0.0)) continue;
                        newMutual -= r2 * Math.log2(r2) * px[neighbor];
                    }
                    if (newMutual < oldMutual) {
                        iterator = ((ArrayList)neighbors.get((int)var14_24)).iterator();
                        while (iterator.hasNext()) {
                            neighbor = (Integer)iterator.next();
                            int[] nArray = neighborhoodClusterSize[neighbor];
                            int n5 = y[var14_24];
                            nArray[n5] = nArray[n5] - 1;
                            int[] nArray2 = neighborhoodClusterSize[neighbor];
                            int n6 = mostSignificantNeighborhoodCluster[var14_24];
                            nArray2[n6] = nArray2[n6] + 1;
                            int mi = mostSignificantNeighborhoodCluster[var14_24];
                            int mk = mostSignificantNeighborhoodCluster[neighbor];
                            if (neighborhoodClusterSize[neighbor][mi] <= neighborhoodClusterSize[neighbor][mk]) continue;
                            mostSignificantNeighborhoodCluster[neighbor] = mostSignificantNeighborhoodCluster[var14_24];
                        }
                        int n7 = y[var14_24];
                        this.size[n7] = this.size[n7] - 1;
                        int n8 = mostSignificantNeighborhoodCluster[var14_24];
                        this.size[n8] = this.size[n8] + 1;
                        y[var14_24] = mostSignificantNeighborhoodCluster[var14_24];
                    }
                }
                ++var14_24;
            }
            double d = this.entropy;
            this.entropy = 0.0;
            for (i = 0; i < n; ++i) {
                if (((ArrayList)neighbors.get(i)).isEmpty()) continue;
                int ni = ((ArrayList)neighbors.get(i)).size();
                double m = 0.0;
                for (int j = 0; j < k; ++j) {
                    double r = (double)neighborhoodClusterSize[i][j] / (double)ni;
                    if (!(r > 0.0)) continue;
                    m -= r * Math.log2(r);
                }
                this.entropy += (m *= px[i]);
            }
            eps = d - this.entropy;
        }
        boolean bl = false;
        for (int i6 = 0; i6 < k; ++i6) {
            if (this.size[i6] <= 0) continue;
            ++var14_27;
        }
        int[] count = new int[var14_27];
        int j = 0;
        for (i = 0; i < k; ++i) {
            if (this.size[i] <= 0) continue;
            count[j] = this.size[i];
            this.size[i] = j++;
        }
        for (i = 0; i < n; ++i) {
            y[i] = this.size[y[i]];
        }
        this.k = var14_27;
        this.size = count;
    }

    public double entropy() {
        return this.entropy;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public int predict(T x) {
        ArrayList neighbors = new ArrayList();
        this.nns.range(x, this.radius, neighbors);
        if (neighbors.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        int[] label = new int[this.k];
        for (Neighbor neighbor : neighbors) {
            int yi;
            int n = yi = this.y[neighbor.index];
            label[n] = label[n] + 1;
        }
        return Math.whichMax(label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("MEC cluster conditional entropy: %.5f%n", this.entropy));
        sb.append(String.format("Clusters of %d data points:%n", this.y.length));
        for (int i = 0; i < this.k; ++i) {
            int r = (int)Math.round(1000.0 * (double)this.size[i] / (double)this.y.length);
            sb.append(String.format("%3d\t%5d (%2d.%1d%%)%n", i, this.size[i], r / 10, r % 10));
        }
        return sb.toString();
    }
}

