/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.SVM;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.math.kernel.GaussianKernel;
import smile.math.kernel.LinearKernel;
import smile.math.kernel.PolynomialKernel;

public class SVMTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLinear() {
        SVM<double[]> svm = new SVM<double[]>(new LinearKernel(), 10.0);
        svm.learn(new double[]{3.0, 0.0, 0.0, 0.0}, 1);
        svm.learn(new double[]{1.0, 0.0, 1.0, 0.0}, 1);
        svm.learn(new double[]{0.0, 2.0, 0.0, 0.0}, 0);
        svm.learn(new double[]{0.0, 1.0, 0.0, 0.0}, 0);
        svm.learn(new double[]{0.0, 0.0, 1.0, 0.0}, 1);
        svm.learn(new double[]{0.0, 0.0, 0.0, 3.0}, 0);
        svm.finish();
        int p = svm.predict(new double[]{0.0, 0.0, 0.0, 1.0});
        System.out.println(p);
    }

    @Test
    public void testLearn() {
        System.out.println("learn");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            int n;
            double[] prob;
            int i;
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            SVM<double[]> svm = new SVM<double[]>(new LinearKernel(), 10.0, Math.max(y) + 1, SVM.Multiclass.ONE_VS_ALL);
            svm.learn((T[])x, y);
            svm.learn((T[])x, y);
            svm.finish();
            int error = 0;
            for (i = 0; i < x.length; ++i) {
                if (svm.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("Linear ONE vs. ALL error = " + error);
            Assert.assertTrue(error <= 10);
            svm = new SVM<double[]>(new GaussianKernel(1.0), 1.0, Math.max(y) + 1, SVM.Multiclass.ONE_VS_ALL);
            svm.learn((T[])x, y);
            svm.learn((T[])x, y);
            svm.finish();
            svm.trainPlattScaling((T[])x, y);
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (svm.predict(x[i]) != y[i]) {
                    ++error;
                }
                prob = new double[3];
                n = svm.predict(x[i], prob);
            }
            System.out.println("Gaussian ONE vs. ALL error = " + error);
            Assert.assertTrue(error <= 5);
            svm = new SVM<double[]>(new GaussianKernel(1.0), 1.0, Math.max(y) + 1, SVM.Multiclass.ONE_VS_ONE);
            svm.learn((T[])x, y);
            svm.learn((T[])x, y);
            svm.finish();
            Assert.assertTrue(!svm.hasPlattScaling());
            svm.trainPlattScaling((T[])x, y);
            Assert.assertTrue(svm.hasPlattScaling());
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (svm.predict(x[i]) != y[i]) {
                    ++error;
                }
                prob = new double[3];
                n = svm.predict(x[i], prob);
            }
            System.out.println("Gaussian ONE vs. ONE error = " + error);
            Assert.assertTrue(error <= 5);
            svm = new SVM<double[]>(new PolynomialKernel(2), 1.0, Math.max(y) + 1, SVM.Multiclass.ONE_VS_ALL);
            svm.learn((T[])x, y);
            svm.learn((T[])x, y);
            svm.finish();
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (svm.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("Polynomial ONE vs. ALL error = " + error);
            Assert.assertTrue(error <= 5);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void testSegment() {
        System.out.println("Segment");
        ArffParser parser = new ArffParser();
        parser.setResponseIndex(19);
        try {
            AttributeDataset train = parser.parse(IOUtils.getTestDataFile("weka/segment-challenge.arff"));
            AttributeDataset test = parser.parse(IOUtils.getTestDataFile("weka/segment-test.arff"));
            System.out.println(train.size() + " " + test.size());
            double[][] x = (double[][])train.toArray((E[])new double[0][]);
            int[] y = train.toArray(new int[0]);
            double[][] testx = (double[][])test.toArray((E[])new double[0][]);
            int[] testy = test.toArray(new int[0]);
            SVM<double[]> svm = new SVM<double[]>(new GaussianKernel(8.0), 5.0, Math.max(y) + 1, SVM.Multiclass.ONE_VS_ALL);
            svm.learn((T[])x, y);
            svm.finish();
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (svm.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("Segment error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertTrue(error < 70);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            int i;
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            SVM<double[]> svm = new SVM<double[]>(new GaussianKernel(8.0), 5.0, Math.max(y) + 1, SVM.Multiclass.ONE_VS_ONE);
            svm.learn((T[])x, y);
            svm.finish();
            int error = 0;
            for (i = 0; i < testx.length; ++i) {
                if (svm.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertTrue(error < 95);
            System.out.println("USPS one more epoch...");
            for (i = 0; i < x.length; ++i) {
                int j = Math.randomInt(x.length);
                svm.learn(x[j], y[j]);
            }
            svm.finish();
            error = 0;
            for (i = 0; i < testx.length; ++i) {
                if (svm.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertTrue(error < 95);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

