/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.RDA;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.validation.LOOCV;

public class RDATest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn() {
        System.out.println("learn");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            RDA rda;
            int[] trainy;
            double[][] trainx;
            int i;
            RDA rda2;
            int[] trainy2;
            double[][] trainx2;
            int i2;
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (i2 = 0; i2 < n; ++i2) {
                trainx2 = (double[][])Math.slice(x, loocv.train[i2]);
                rda2 = new RDA(trainx2, trainy2 = Math.slice(y, loocv.train[i2]), 0.0);
                if (y[loocv.test[i2]] == rda2.predict(x[loocv.test[i2]])) continue;
                ++error;
            }
            System.out.println("RDA (0.0) error = " + error);
            Assert.assertEquals(22L, error);
            error = 0;
            for (i2 = 0; i2 < n; ++i2) {
                trainx2 = (double[][])Math.slice(x, loocv.train[i2]);
                rda2 = new RDA(trainx2, trainy2 = Math.slice(y, loocv.train[i2]), 0.1);
                if (y[loocv.test[i2]] == rda2.predict(x[loocv.test[i2]])) continue;
                ++error;
            }
            System.out.println("RDA (0.1) error = " + error);
            Assert.assertEquals(24L, error);
            error = 0;
            for (i2 = 0; i2 < n; ++i2) {
                trainx2 = (double[][])Math.slice(x, loocv.train[i2]);
                rda2 = new RDA(trainx2, trainy2 = Math.slice(y, loocv.train[i2]), 0.2);
                if (y[loocv.test[i2]] == rda2.predict(x[loocv.test[i2]])) continue;
                ++error;
            }
            System.out.println("RDA (0.2) error = " + error);
            Assert.assertEquals(20L, error);
            error = 0;
            for (i2 = 0; i2 < n; ++i2) {
                trainx2 = (double[][])Math.slice(x, loocv.train[i2]);
                rda2 = new RDA(trainx2, trainy2 = Math.slice(y, loocv.train[i2]), 0.3);
                if (y[loocv.test[i2]] == rda2.predict(x[loocv.test[i2]])) continue;
                ++error;
            }
            System.out.println("RDA (0.3) error = " + error);
            Assert.assertEquals(19L, error);
            error = 0;
            for (i2 = 0; i2 < n; ++i2) {
                trainx2 = (double[][])Math.slice(x, loocv.train[i2]);
                rda2 = new RDA(trainx2, trainy2 = Math.slice(y, loocv.train[i2]), 0.4);
                if (y[loocv.test[i2]] == rda2.predict(x[loocv.test[i2]])) continue;
                ++error;
            }
            System.out.println("RDA (0.4) error = " + error);
            Assert.assertEquals(16L, error);
            error = 0;
            for (i2 = 0; i2 < n; ++i2) {
                trainx2 = (double[][])Math.slice(x, loocv.train[i2]);
                rda2 = new RDA(trainx2, trainy2 = Math.slice(y, loocv.train[i2]), 0.5);
                if (y[loocv.test[i2]] == rda2.predict(x[loocv.test[i2]])) continue;
                ++error;
            }
            System.out.println("RDA (0.5) error = " + error);
            Assert.assertEquals(12L, error);
            error = 0;
            for (i2 = 0; i2 < n; ++i2) {
                trainx2 = (double[][])Math.slice(x, loocv.train[i2]);
                rda2 = new RDA(trainx2, trainy2 = Math.slice(y, loocv.train[i2]), 0.6);
                if (y[loocv.test[i2]] == rda2.predict(x[loocv.test[i2]])) continue;
                ++error;
            }
            System.out.println("RDA (0.6) error = " + error);
            Assert.assertEquals(11L, error);
            error = 0;
            for (i2 = 0; i2 < n; ++i2) {
                trainx2 = (double[][])Math.slice(x, loocv.train[i2]);
                rda2 = new RDA(trainx2, trainy2 = Math.slice(y, loocv.train[i2]), 0.7);
                if (y[loocv.test[i2]] == rda2.predict(x[loocv.test[i2]])) continue;
                ++error;
            }
            System.out.println("RDA (0.7) error = " + error);
            Assert.assertEquals(9L, error);
            error = 0;
            double[] posteriori = new double[3];
            for (i = 0; i < n; ++i) {
                trainx = (double[][])Math.slice(x, loocv.train[i]);
                rda = new RDA(trainx, trainy = Math.slice(y, loocv.train[i]), 0.8);
                if (y[loocv.test[i]] == rda.predict(x[loocv.test[i]], posteriori)) continue;
                ++error;
            }
            System.out.println("RDA (0.8) error = " + error);
            Assert.assertEquals(6L, error);
            error = 0;
            for (i = 0; i < n; ++i) {
                trainx = (double[][])Math.slice(x, loocv.train[i]);
                rda = new RDA(trainx, trainy = Math.slice(y, loocv.train[i]), 0.9);
                if (y[loocv.test[i]] == rda.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("RDA (0.9) error = " + error);
            Assert.assertEquals(3L, error);
            error = 0;
            for (i = 0; i < n; ++i) {
                trainx = (double[][])Math.slice(x, loocv.train[i]);
                rda = new RDA(trainx, trainy = Math.slice(y, loocv.train[i]), 1.0);
                if (y[loocv.test[i]] == rda.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("RDA (1.0) error = " + error);
            Assert.assertEquals(4L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            RDA rda = new RDA(x, y, 0.7);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (rda.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertEquals(235L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

