/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.QDA;
import smile.data.AttributeDataset;
import smile.data.parser.ArffParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.validation.LOOCV;

public class QDATest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn() {
        System.out.println("learn");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            double[] posteriori = new double[3];
            for (int i = 0; i < n; ++i) {
                int[] trainy;
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                QDA qda = new QDA(trainx, trainy = Math.slice(y, loocv.train[i]));
                if (y[loocv.test[i]] == qda.predict(x[loocv.test[i]], posteriori)) continue;
                ++error;
            }
            System.out.println("QDA error = " + error);
            Assert.assertEquals(4L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

