/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.io.IOException;
import java.text.ParseException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.KNN;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;

public class KNNTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn_3args() {
        System.out.println("learn");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            int i;
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[0][]);
            int[] y = iris.toArray(new int[0]);
            KNN<double[]> knn = KNN.learn(x, y, 1);
            int error = 0;
            for (i = 0; i < x.length; ++i) {
                if (knn.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("1-nn error = " + error);
            Assert.assertEquals(6L, error);
            knn = KNN.learn(x, y, 3);
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (knn.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("3-nn error = " + error);
            Assert.assertEquals(6L, error);
            knn = KNN.learn(x, y, 5);
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (knn.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("5-nn error = " + error);
            Assert.assertEquals(5L, error);
            knn = KNN.learn(x, y, 7);
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (knn.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("7-nn error = " + error);
            Assert.assertEquals(5L, error);
            knn = KNN.learn(x, y, 9);
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (knn.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("9-nn error = " + error);
            Assert.assertEquals(5L, error);
            knn = KNN.learn(x, y, 11);
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (knn.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("11-nn error = " + error);
            Assert.assertEquals(4L, error);
            knn = KNN.learn(x, y, 13);
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (knn.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("13-nn error = " + error);
            Assert.assertEquals(5L, error);
            knn = KNN.learn(x, y, 15);
            error = 0;
            for (i = 0; i < x.length; ++i) {
                if (knn.predict(x[i]) == y[i]) continue;
                ++error;
            }
            System.out.println("15-nn error = " + error);
            Assert.assertEquals(4L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testSegment() throws ParseException {
        System.out.println("Segment");
        ArffParser parser = new ArffParser();
        parser.setResponseIndex(19);
        try {
            AttributeDataset train = parser.parse(IOUtils.getTestDataFile("weka/segment-challenge.arff"));
            AttributeDataset test = parser.parse(IOUtils.getTestDataFile("weka/segment-test.arff"));
            double[][] x = (double[][])train.toArray((E[])new double[0][]);
            int[] y = train.toArray(new int[0]);
            double[][] testx = (double[][])test.toArray((E[])new double[0][]);
            int[] testy = test.toArray(new int[0]);
            KNN<double[]> knn = KNN.learn(x, y);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (knn.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("Segment error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertEquals(39L, error);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            KNN<double[]> knn = KNN.learn(x, y);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (knn.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertEquals(113L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

