/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.DecisionTree;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.sort.QuickSort;
import smile.validation.LOOCV;

public class DecisionTreeTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testWeather() {
        System.out.println("Weather");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset weather = arffParser.parse(IOUtils.getTestDataFile("weka/weather.nominal.arff"));
            double[][] x = (double[][])weather.toArray((E[])new double[weather.size()][]);
            int[] y = weather.toArray(new int[weather.size()]);
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                int[] trainy = Math.slice(y, loocv.train[i]);
                DecisionTree tree = new DecisionTree(weather.attributes(), trainx, trainy, 3);
                if (y[loocv.test[i]] == tree.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Decision Tree error = " + error);
            Assert.assertEquals(5L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testIris() {
        System.out.println("Iris");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                int[] trainy = Math.slice(y, loocv.train[i]);
                DecisionTree tree = new DecisionTree(iris.attributes(), trainx, trainy, 4);
                if (y[loocv.test[i]] == tree.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Decision Tree error = " + error);
            Assert.assertEquals(7L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            DecisionTree tree = new DecisionTree(x, y, 350, DecisionTree.SplitRule.ENTROPY);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (tree.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertEquals(328L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPSNominal() {
        System.out.println("USPS nominal");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            int i;
            int i2;
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            for (double[] xi : x) {
                for (i2 = 0; i2 < xi.length; ++i2) {
                    xi[i2] = Math.round(255.0 * (xi[i2] + 1.0) / 2.0);
                }
            }
            for (double[] xi : testx) {
                for (i2 = 0; i2 < xi.length; ++i2) {
                    xi[i2] = Math.round(127.0 + 127.0 * xi[i2]);
                }
            }
            Attribute[] attributes = new Attribute[256];
            String[] values = new String[attributes.length];
            for (i = 0; i < attributes.length; ++i) {
                values[i] = String.valueOf(i);
            }
            for (i = 0; i < attributes.length; ++i) {
                attributes[i] = new NominalAttribute("V" + i, values);
            }
            DecisionTree tree = new DecisionTree(attributes, x, y, 350, 2, DecisionTree.SplitRule.ENTROPY);
            int error = 0;
            for (i2 = 0; i2 < testx.length; ++i2) {
                if (tree.predict(testx[i2]) == testy[i2]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            double[] importance = tree.importance();
            int[] index = QuickSort.sort(importance);
            int i3 = importance.length;
            while (i3-- > 0) {
                System.out.format("%s importance is %.4f%n", train.attributes()[index[i3]], importance[i3]);
            }
            Assert.assertEquals(324L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

