/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;

public class SerOptional {
    private static final Map<Class<?>, Object[]> OPTIONALS;

    public static Object extractValue(MetaProperty<?> metaProp, Bean bean) {
        Object[] helpers;
        Object value = metaProp.get(bean);
        if (value != null && (helpers = OPTIONALS.get(metaProp.propertyType())) != null) {
            try {
                boolean present = (Boolean)((Method)helpers[2]).invoke(value, new Object[0]);
                value = present ? ((Method)helpers[3]).invoke(value, new Object[0]) : null;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return value;
    }

    public static Class<?> extractType(MetaProperty<?> metaProp, Class<?> beanType) {
        Class<?> type = metaProp.propertyType();
        Object[] helpers = OPTIONALS.get(type);
        if (helpers != null) {
            try {
                Class<?> genericType = JodaBeanUtils.extractTypeClass(metaProp, beanType, 1, 0);
                type = genericType != null ? genericType : type;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return type;
    }

    public static Object wrapValue(MetaProperty<?> metaProp, Class<?> beanType, Object value) {
        Object[] helpers = OPTIONALS.get(metaProp.propertyType());
        if (helpers != null) {
            try {
                value = value != null ? ((Method)helpers[0]).invoke(null, value) : helpers[1];
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return value;
    }

    static {
        Method get;
        Method isPresent;
        Object nullConstant;
        Method create;
        Class<?> cls;
        HashMap map = new HashMap();
        try {
            cls = Class.forName("com.google.common.base.Optional");
            create = cls.getMethod("of", Object.class);
            nullConstant = cls.getMethod("absent", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls.getMethod("isPresent", new Class[0]);
            get = cls.getMethod("get", new Class[0]);
            map.put(cls, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            cls = Class.forName("java.util.Optional");
            create = cls.getMethod("of", Object.class);
            nullConstant = cls.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls.getMethod("isPresent", new Class[0]);
            get = cls.getMethod("get", new Class[0]);
            map.put(cls, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            cls = Class.forName("java.util.OptionalDouble");
            create = cls.getMethod("of", Double.TYPE);
            nullConstant = cls.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls.getMethod("isPresent", new Class[0]);
            get = cls.getMethod("getAsDouble", new Class[0]);
            map.put(cls, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            cls = Class.forName("java.util.OptionalInt");
            create = cls.getMethod("of", Integer.TYPE);
            nullConstant = cls.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls.getMethod("isPresent", new Class[0]);
            get = cls.getMethod("getAsInt", new Class[0]);
            map.put(cls, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            cls = Class.forName("java.util.OptionalLong");
            create = cls.getMethod("of", Long.TYPE);
            nullConstant = cls.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls.getMethod("isPresent", new Class[0]);
            get = cls.getMethod("getAsLong", new Class[0]);
            map.put(cls, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception exception) {
            // empty catch block
        }
        OPTIONALS = map.isEmpty() ? Collections.emptyMap() : map;
    }
}

