/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.RealParamAnimateable;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class Symmetric_K_Noid
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.Symmetric_K_Noid.MainEx", 6);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Symmetric_K_Noid.aa", 0.0, 0.0, 1.0);
    private int ex;
    private int ex_;
    private int e_odd;
    private double AA;
    private double r1;
    private double rex;
    private double re_e;
    private Complex q1;

    public Symmetric_K_Noid() {
        this.addParameter(this.aa);
        this.aa.setMinimumValueForInput(0.0);
        this.addParameter(this.exponent);
        this.exponent.setMinimumValueForInput(3);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(-26.0, 10.0, -43.0));
        this.setDefaultWindow(-7.0, 7.0, -6.0, 6.0);
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(8);
        this.umin.reset(-2.5);
        this.umax.reset(2.5);
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(0.0);
        this.removeParameter(this.vmax);
        this.removeParameter(this.vmin);
        this.canShowConjugateSurface = true;
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        if (!this.inAssociateMorph) {
            int e;
            GridTransformMatrix[] trList = new GridTransformMatrix[this.ex * 2];
            trList[0] = new GridTransformMatrix();
            if (this.flag0) {
                trList[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
                this.data.addGridTransform(trList[1]);
            } else if (this.flag05) {
                trList[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                this.data.addGridTransform(trList[1]);
            }
            if (this.flag0 || this.flag05) {
                for (e = 2; e < this.ex; ++e) {
                    trList[e] = new GridTransformMatrix(trList[e - 2]).rotateZ(-720.0 / (double)this.ex);
                    this.data.addGridTransform(trList[e]);
                }
            }
            if (this.flag0) {
                for (e = 0; e < this.ex; ++e) {
                    trList[this.ex + e] = new GridTransformMatrix(trList[e]).scale(1.0, 1.0, -1.0);
                    this.data.addGridTransform(trList[this.ex + e]);
                }
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double r = Math.exp(u);
        Complex z = new Complex(r * Math.cos(v), r * Math.sin(v));
        Complex w = new Complex(-z.re + 1.0, -z.im);
        Complex aux = new Complex(z.re + 1.0, z.im);
        w = w.dividedBy(aux);
        z = w.logNearer(I_C);
        z.assignTimes(2.0 / (double)this.ex);
        return z.exponential();
    }

    @Override
    protected Complex gauss(Complex z) {
        if (this.e_odd > 0) {
            return z.integerPower(this.e_odd);
        }
        Complex wk = z.integerPower(this.ex_ - 1);
        Complex w = z.times(wk);
        Complex aux = w.times(-this.rex);
        aux.re += 1.0;
        w.re -= this.rex;
        w = wk.times(w).dividedBy(aux);
        return w;
    }

    @Override
    protected Complex hPrime(Complex z) {
        if (this.e_odd > 0) {
            Complex w = z.integerPower(this.ex - 1);
            Complex w2 = z.times(w);
            w2.re -= 1.0;
            w2.assignTimes(w2);
            return w.dividedBy(w2.times(2.0 / (double)this.exponent.getValue()));
        }
        Complex wk = z.integerPower(this.ex_ - 1);
        Complex w = z.times(wk);
        Complex w2 = w.times(w);
        w2.re += 1.0;
        Complex aux = w2.times(-this.re_e);
        aux.assignPlus(w);
        aux.assignTimes(wk);
        w2.re -= 2.0;
        w2.assignTimes(w2);
        return aux.dividedBy(w2.times(2.0 / (double)this.exponent.getValue()));
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.AA = Math.sqrt(this.aa.getValue());
        this.ex = this.exponent.getValue();
        this.e_odd = 0;
        if ((double)this.ex / 2.0 - Math.floor((double)this.ex / 2.0) == 0.5) {
            this.e_odd = this.ex - 1;
            this.rex = 0.0;
        } else {
            this.ex_ = (int)Math.floor((double)this.ex / 2.0);
            this.rex = Math.pow(this.AA, this.ex_);
            this.re_e = this.rex / (this.rex * this.rex + 1.0);
        }
    }

    @Override
    protected ComplexVector3D getCenter() {
        ComplexVector3D gC = new ComplexVector3D(this.helperArray[(int)Math.floor(this.ucount / 2)][this.vcount - 1]);
        gC.z = new Complex(this.helperArray[0][0].z.plus(this.helperArray[this.ucount - 1][0].z).times(0.5));
        return gC;
    }
}

