/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class SchoenGyroid
extends WeierstrassMinimalSurface {
    private double Phi1;
    private double Phi2;
    private double rp1;
    private double RP2;
    private double r1_;
    private double R2_;
    private double scale;
    private Vector3D trans;
    private Vector3D transX;
    private Vector3D transY;
    private Vector3D transZ;
    private Vector3D N_6;
    private Vector3D N_2;
    private Vector3D N5_6;
    private Vector3D surf_6;
    private Vector3D surf_2;
    private Vector3D surf5_6;
    private Vector3D trans_6;
    private Vector3D trans_2;
    private Vector3D trans5_6;
    private GridTransformMatrix m_6;
    private GridTransformMatrix m_2;
    private GridTransformMatrix m5_6;

    public SchoenGyroid() {
        this.setDefaultOrientation(0);
        this.setDefaultViewUp(new Vector3D(-0.01, 0.69, 0.72));
        this.setDefaultViewpoint(new Vector3D(-25.0, -32.0, 29.0));
        this.setDefaultWindow(-3.0, 3.0, -2.8, 2.2);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(0.005);
        this.umax.reset(0.997);
        this.vmin.reset(0.0);
        this.vmax.reset(1.0);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.afp.setValue(0.9074490379894117);
        this.iFirstInHelper = false;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(12);
        float c0 = 0.25f;
        view.getLightSettings().setAmbientLight(new Color(c0, c0, c0));
        view.getLightSettings().setSpecularExponent(95);
        view.getLightSettings().setSpecularRatio(0.8f);
        return view;
    }

    @Override
    protected void createData() {
        super.createData();
        this.computePeriodData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] trList = new GridTransformMatrix[80];
        trList[0] = new GridTransformMatrix();
        GridTransformMatrix a = new GridTransformMatrix();
        trList[1] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
        if (!this.wantsToSeeDomain) {
            this.data.addGridTransform(trList[1]);
            a = new GridTransformMatrix().scale(-1.0, -1.0, 1.0);
            this.trans = new Vector3D(this.transZ.x, this.transZ.y, 0.0);
            trList[2] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
            trList[3] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
            this.data.addGridTransform(trList[2]);
            this.data.addGridTransform(trList[3]);
            this.trans = new Vector3D(-this.transZ.x, -this.transZ.y, 0.0);
            trList[4] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
            trList[5] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
            this.data.addGridTransform(trList[4]);
            this.data.addGridTransform(trList[5]);
            a = new GridTransformMatrix().scale(-1.0, 1.0, -1.0);
            this.trans = new Vector3D(this.transY.x, 0.0, this.transY.z);
            trList[6] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
            trList[7] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
            this.data.addGridTransform(trList[6]);
            this.data.addGridTransform(trList[7]);
            this.trans = new Vector3D(-this.transY.x, 0.0, -this.transY.z);
            trList[8] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
            trList[9] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
            this.data.addGridTransform(trList[8]);
            this.data.addGridTransform(trList[9]);
            a = new GridTransformMatrix().scale(1.0, -1.0, -1.0);
            this.trans = new Vector3D(0.0, this.transX.y, this.transX.z);
            trList[10] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
            trList[11] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
            this.data.addGridTransform(trList[10]);
            this.data.addGridTransform(trList[11]);
            this.trans = new Vector3D(0.0, -this.transX.y, -this.transX.z);
            trList[12] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
            trList[13] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
            this.data.addGridTransform(trList[12]);
            this.data.addGridTransform(trList[13]);
            trList[14] = new GridTransformMatrix(trList[0]).leftMultiplyBy(this.m_6).translate(this.trans_6);
            trList[15] = new GridTransformMatrix(trList[1]).leftMultiplyBy(this.m_6).translate(this.trans_6);
            this.data.addGridTransform(trList[14]);
            this.data.addGridTransform(trList[15]);
            this.trans = new Vector3D(this.trans_6.negated());
            trList[16] = new GridTransformMatrix(trList[0]).leftMultiplyBy(this.m_6).translate(this.trans);
            trList[17] = new GridTransformMatrix(trList[1]).leftMultiplyBy(this.m_6).translate(this.trans);
            this.data.addGridTransform(trList[16]);
            this.data.addGridTransform(trList[17]);
            trList[18] = new GridTransformMatrix(trList[0]).leftMultiplyBy(this.m_2).translate(this.trans_2);
            trList[19] = new GridTransformMatrix(trList[1]).leftMultiplyBy(this.m_2).translate(this.trans_2);
            this.data.addGridTransform(trList[18]);
            this.data.addGridTransform(trList[19]);
            this.trans = new Vector3D(this.trans_2.negated());
            trList[20] = new GridTransformMatrix(trList[0]).leftMultiplyBy(this.m_2).translate(this.trans);
            trList[21] = new GridTransformMatrix(trList[1]).leftMultiplyBy(this.m_2).translate(this.trans);
            this.data.addGridTransform(trList[20]);
            this.data.addGridTransform(trList[21]);
            trList[22] = new GridTransformMatrix(trList[0]).leftMultiplyBy(this.m5_6).translate(this.trans5_6);
            trList[23] = new GridTransformMatrix(trList[1]).leftMultiplyBy(this.m5_6).translate(this.trans5_6);
            this.data.addGridTransform(trList[22]);
            this.data.addGridTransform(trList[23]);
            this.trans = new Vector3D(this.trans5_6.negated());
            trList[24] = new GridTransformMatrix(trList[0]).leftMultiplyBy(this.m5_6).translate(this.trans);
            trList[25] = new GridTransformMatrix(trList[1]).leftMultiplyBy(this.m5_6).translate(this.trans);
            this.data.addGridTransform(trList[24]);
            this.data.addGridTransform(trList[25]);
            if (this.getNumberOfPieces() == 2) {
                this.trans = new Vector3D(this.trans_2.negated());
                trList[26] = new GridTransformMatrix(trList[12]).leftMultiplyBy(this.m_2).translate(this.trans);
                trList[27] = new GridTransformMatrix(trList[13]).leftMultiplyBy(this.m_2).translate(this.trans);
                this.data.addGridTransform(trList[26]);
                this.data.addGridTransform(trList[27]);
                trList[28] = new GridTransformMatrix(trList[2]).leftMultiplyBy(this.m_6).translate(this.trans_6);
                trList[29] = new GridTransformMatrix(trList[3]).leftMultiplyBy(this.m_6).translate(this.trans_6);
                this.data.addGridTransform(trList[28]);
                this.data.addGridTransform(trList[29]);
                trList[30] = new GridTransformMatrix(trList[6]).leftMultiplyBy(this.m5_6).translate(this.trans5_6);
                trList[31] = new GridTransformMatrix(trList[7]).leftMultiplyBy(this.m5_6).translate(this.trans5_6);
                this.data.addGridTransform(trList[30]);
                this.data.addGridTransform(trList[31]);
                trList[32] = new GridTransformMatrix(trList[6]).leftMultiplyBy(this.m_6).translate(this.trans_6);
                trList[33] = new GridTransformMatrix(trList[7]).leftMultiplyBy(this.m_6).translate(this.trans_6);
                this.data.addGridTransform(trList[32]);
                this.data.addGridTransform(trList[33]);
                trList[34] = new GridTransformMatrix(trList[4]).leftMultiplyBy(this.m_2).translate(this.trans_2);
                trList[35] = new GridTransformMatrix(trList[5]).leftMultiplyBy(this.m_2).translate(this.trans_2);
                this.data.addGridTransform(trList[34]);
                this.data.addGridTransform(trList[35]);
            }
            if (!this.inAssociateMorph) {
                // empty if block
            }
        }
    }

    public static double paramRescale(double x) {
        double y = Math.sin(1.5707963267948966 * x);
        return y * y;
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double ph = 0.0;
        double r = Math.sin(1.5707963267948966 * u);
        if (v <= 0.3333333333333333) {
            ph = -Math.PI + this.Phi1 * SchoenGyroid.paramRescale(3.0 * v);
        } else if (v > 0.3333333333333333 && v <= 0.6666666666666666) {
            ph = -Math.PI + this.Phi1 + (this.Phi2 - this.Phi1) * SchoenGyroid.paramRescale(3.0 * v - 1.0);
        } else if (v > 0.6666666666666666) {
            ph = -Math.PI + this.Phi2 + (Math.PI - this.Phi2) * SchoenGyroid.paramRescale(3.0 * v - 2.0);
        }
        Complex z = new Complex(r * Math.cos(ph), r * Math.sin(ph));
        if (this.wantsToSeeGaussImage) {
            z = this.gauss(z);
        }
        return z;
    }

    @Override
    protected Complex gauss(Complex z) {
        Complex z2 = z.times(z);
        Complex z2_ = new Complex(1.0 - z2.re, -z2.im);
        z2.re = 1.0 + z2.re;
        Complex w = z2_.inverse().times(z2);
        double x = -2.0 * w.im - this.r1_;
        w.im = 2.0 * w.re;
        w.re = x;
        Complex aux = w.times(-2.0 / (this.R2_ - this.r1_));
        aux.re = -aux.re - 1.0;
        aux.im = -aux.im;
        Complex aux2 = aux.times(aux);
        aux2.re -= 1.0;
        Complex g2 = aux2.squareRootNearer(aux).minus(aux);
        return g2.squareRootNearer(I1_C);
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex z2 = z.times(z);
        z2.re -= 1.0;
        Complex w = this.gauss(z);
        Complex g2 = w.times(w);
        Complex g4 = g2.times(g2);
        g4.re -= 1.0;
        g4.assignTimes(z2);
        w = g4.inverse().times(g2);
        w.assignTimes(this.scale);
        return w;
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.AFP = this.afp.getValue();
        this.Phi1 = 1.0471975511965976;
        this.Phi2 = 2.0943951023931953;
        this.rp1 = Math.tan(this.Phi1 / 2.0);
        this.RP2 = Math.tan(this.Phi2 / 2.0);
        this.r1_ = this.rp1 - 1.0 / this.rp1;
        this.R2_ = this.RP2 - 1.0 / this.RP2;
        this.scale = 1.0;
    }

    @Override
    protected ComplexVector3D getCenter() {
        ComplexVector3D gC = new ComplexVector3D(this.helperArray[0][0]);
        gC = gC.plus(this.helperArray[0][this.vcount - 1]).times(0.5);
        return gC;
    }

    public void computePeriodData() {
        ComplexVector3D aux = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(0.0)]));
        this.transZ = aux.re().times(2.0 * Math.cos(this.AFP)).plus(aux.im().times(2.0 * Math.sin(this.AFP)));
        aux = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor((double)this.vcount * 1.0 / 3.0)]));
        this.transX = aux.re().times(2.0 * Math.cos(this.AFP)).plus(aux.im().times(2.0 * Math.sin(this.AFP)));
        aux = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor((double)this.vcount * 2.0 / 3.0)]));
        this.transY = aux.re().times(2.0 * Math.cos(this.AFP)).plus(aux.im().times(2.0 * Math.sin(this.AFP)));
        this.surf_6 = this.surfacePoint(this.umax.getValue(), 0.16666666666666666);
        this.N_6 = this.surfaceNormal(this.umax.getValue(), 0.16666666666666666);
        double sc = this.surf_6.dot(this.N_6);
        this.trans_6 = this.surf_6.linComb(2.0, -2.0 * sc, this.N_6);
        this.m_6 = GridTransformMatrix.SetGridTransformMatrix(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, true);
        this.surf_2 = this.surfacePoint(this.umax.getValue(), 0.5);
        this.N_2 = this.surfaceNormal(this.umax.getValue(), 0.5);
        sc = this.surf_2.dot(this.N_2);
        this.trans_2 = this.surf_2.linComb(2.0, -2.0 * sc, this.N_2);
        this.m_2 = GridTransformMatrix.SetGridTransformMatrix(0.0, -1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, true);
        this.surf5_6 = this.surfacePoint(this.umax.getValue(), 0.8333333333333334);
        this.N5_6 = this.surfaceNormal(this.umax.getValue(), 0.8333333333333334);
        sc = this.surf5_6.dot(this.N5_6);
        this.trans5_6 = this.surf5_6.linComb(2.0, -2.0 * sc, this.N5_6);
        this.m5_6 = GridTransformMatrix.SetGridTransformMatrix(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, true);
    }
}

