/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class MoebiusStrip
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 1.5, 1.5, 1.5);
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 1.0, 1.0, 1.0);

    public MoebiusStrip() {
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.umin.reset("-0.3");
        this.umax.reset("0.3");
        this.vmin.reset("0.0");
        this.vmax.reset("2*pi", "0.3", "2*pi");
        this.uPatchCount.setValueAndDefault(3);
        this.vPatchCount.setValueAndDefault(21);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double halftwists = Math.round(this.bb.getValue());
        return new Vector3D(AA * (MoebiusStrip.cos(v) + u * MoebiusStrip.cos(halftwists * v / 2.0) * MoebiusStrip.cos(v)), AA * (MoebiusStrip.sin(v) + u * MoebiusStrip.cos(halftwists * v / 2.0) * MoebiusStrip.sin(v)), AA * u * MoebiusStrip.sin(halftwists * v / 2.0));
    }
}

