/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class CatenoidFence
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.CatenoidFence.aa", 0.0, -2.0, 2.0);
    private IntegerParam pieces = new IntegerParam("vmm.surface.parametric.CatenoidFence.pieces", 1);
    private int jP;
    private int um;
    private int vm;
    double amp = 0.04;
    private double P;
    private double PL;
    private double r1;
    private double R;
    private double R_;
    private double PR;
    private Complex qP;
    private ComplexVector3D halfPeriodII;

    public CatenoidFence() {
        this.addParameter(this.pieces);
        this.addParameter(this.aa);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(25.0, 43.0, -10.0));
        this.setDefaultViewUp(new Vector3D(0.1, -0.3, -1.0));
        this.setDefaultWindow(-7.5, 7.5, -6.0, 6.0);
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.vmax.reset(3.0);
        this.vmin.reset(-this.vmax.getValue());
        this.umin.reset(-3.141492653589793);
        this.umax.reset(3.141492653589793);
        this.removeParameter(this.vmin);
        this.removeParameter(this.umax);
        this.removeParameter(this.umin);
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2, 3};
        this.canShowConjugateSurface = true;
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(6);
        return view;
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.AFP = this.afp.getValue();
        if (param != this.afp) {
            this.needsValueArray = true;
        }
        if (param == this.vmax) {
            this.vmin.reset(-this.vmax.getValue());
        }
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] trList = new GridTransformMatrix[12];
        trList[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            int e;
            if (this.flag0) {
                trList[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0).translate(0.0, 2.0 * this.halfPeriod.y.re, 0.0);
                this.data.addGridTransform(trList[1]);
            }
            if (this.flag05) {
                trList[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).translate(0.0, 0.0, 2.0 * this.halfPeriod.z.im);
                this.data.addGridTransform(trList[1]);
            }
            if (this.getNumberOfPieces() == 2 || this.getNumberOfPieces() == 3) {
                for (e = 0; e < 2; ++e) {
                    if (this.flag0) {
                        trList[e + 2] = new GridTransformMatrix(trList[e]).translate(2.0 * this.halfPeriodII.x.re, 0.0, 0.0);
                        this.data.addGridTransform(trList[e + 2]);
                    }
                    if (!this.flag05) continue;
                    trList[e + 2] = new GridTransformMatrix(trList[e]).translate(0.0, 0.0, -4.0 * this.halfPeriod.z.im);
                    this.data.addGridTransform(trList[e + 2]);
                }
            }
            if (this.getNumberOfPieces() == 3 && this.flag0) {
                for (e = 0; e < 2; ++e) {
                    trList[e + 4] = new GridTransformMatrix(trList[e]).translate(-2.0 * this.halfPeriodII.x.re, 0.0, 0.0);
                    this.data.addGridTransform(trList[e + 4]);
                }
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double r = this.R * Math.exp(v);
        Complex z = new Complex(r * Math.cos(u) + this.P, r * Math.sin(u));
        if (u < this.umin.getValue() + 1.0E-4) {
            z.im = -Math.max(Math.max(-z.im, this.amp - Math.abs(z.re - this.P)), this.amp - Math.abs(z.re - this.P - 1.0 / this.P));
        }
        if (u > this.umax.getValue() - 1.0E-4) {
            z.im = Math.max(Math.max(z.im, this.amp - Math.abs(z.re - this.P)), this.amp - Math.abs(z.re - this.P - 1.0 / this.P));
        }
        return z;
    }

    protected void p_Index() {
        this.jP = (int)Math.floor((this.PL - this.vmin.getValue()) / (this.vmax.getValue() - this.vmin.getValue()) * (double)(this.vcount - 1));
    }

    @Override
    protected Complex gauss(Complex z) {
        double denom = z.re * z.re + z.im * z.im;
        Complex w = new Complex(this.PR * (z.re / denom - z.re) + this.R_, -this.PR * z.im * (1.0 / denom + 1.0));
        w = z.im > 0.0 ? w.squareRootNearer(I2_C) : w.squareRootNearer(I1_C);
        return w;
    }

    @Override
    protected Complex hPrime(Complex z) {
        double denom = ((z.re - this.P) * (z.re - this.P) + z.im * z.im) / this.r1;
        return new Complex((z.re - this.P) / denom, -z.im / denom);
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.P = Math.exp(this.aa.getValue());
        this.R = this.P * this.P + 1.0;
        this.R_ = (this.P * this.P - 1.0) / this.R;
        this.PR = this.P / this.R;
        this.R = Math.sqrt(this.R);
        this.PL = Math.log(this.P / this.R);
        this.qP = new Complex(this.P, 1.25E-5);
        this.r1 = 0.5;
        this.p_Index();
        this.um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        this.vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
    }

    @Override
    protected ComplexVector3D getCenter() {
        return new ComplexVector3D(this.helperArray[this.um][this.vm]);
    }

    @Override
    public void computeHalfPeriod() {
        this.halfPeriod = new ComplexVector3D(this.helperArray[0][0]);
        this.halfPeriod.assign(this.halfPeriod.y.minus(this.halfPeriod.x), this.halfPeriod.y.plus(this.halfPeriod.x).times(I_C), this.halfPeriod.z);
        this.halfPeriodII = new ComplexVector3D(this.helperArray[0][this.vm]);
        this.halfPeriodII.assign(this.halfPeriodII.y.minus(this.halfPeriodII.x), this.halfPeriodII.y.plus(this.halfPeriodII.x).times(I_C), this.halfPeriodII.z);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), this.domainGrid(u, v))));
        ComplexVector3D eW = new ComplexVector3D(auxW.y.minus(auxW.x), auxW.y.plus(auxW.x).times(I_C), auxW.z);
        if (this.AFP == 0.0) {
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }
}

