/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.Quaternion;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class BianchiPinkall
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.BianchiPinkall.aa", 0.25, 0.25, 0.25);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.BianchiPinkall.bb", 0.1, 0.0, 0.1);
    private RealParamAnimateable cc = new RealParamAnimateable("vmm.surface.parametric.BianchiPinkall.cc", 3.0, 3.0, 3.0);
    private RealParamAnimateable dd = new RealParamAnimateable("vmm.surface.parametric.BianchiPinkall.dd", 0.0, 0.0, 0.0);
    double AA;
    double BB;
    double CC;
    double DD;
    Quaternion q0;
    boolean in2ndMorph = false;

    public BianchiPinkall() {
        this.uPatchCount.setValueAndDefault(36);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("0");
        this.umax.reset("2 pi");
        this.vmin.reset("0.01");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(-18.5, -5.1, -3.4));
        this.setDefaultWindow(-4.5, 4.5, -4.5, 4.5);
        this.setDefaultOrientation(0);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.5);
        this.aa.setMinimumValueForInput(0.0);
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.AA = Math.PI * this.aa.getValue();
        this.BB = Math.PI * this.bb.getValue();
        this.BB = Math.max(0.0, Math.min(this.BB, Math.min(this.AA, Math.PI - this.AA)));
        this.CC = 2.0 * this.cc.getValue();
        this.DD = Math.PI * this.dd.getValue();
        this.q0 = this.vFunction(this.AA, this.BB, this.CC, 0.0);
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.BianchiPinkall.RotateAroundCircle")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicAnimator animation = new BasicAnimator();
                animation.setLooping(1);
                animation.setUseFilmstrip(BianchiPinkall.this.getUseFilmstripForMorphing());
                animation.setFrames(BianchiPinkall.this.getFramesForMorphing());
                animation.setMillisecondsPerFrame(200);
                animation.addWithCustomLimits(BianchiPinkall.this.dd, 0.0, 2.0);
                animation.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        BianchiPinkall.this.in2ndMorph = ((BasicAnimator)evt.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    public Quaternion vFunction(double a, double b, double c, double v) {
        double am = a + b * Math.sin(c * v);
        return new Quaternion(Math.cos(am) * Math.cos(v), Math.cos(am) * Math.sin(v), Math.sin(am) * Math.cos(v), -Math.sin(am) * Math.sin(v));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        Quaternion eiu = new Quaternion(Math.cos(u), Math.sin(u), 0.0, 0.0);
        Quaternion qv = this.vFunction(this.AA, this.BB, this.CC, v);
        Quaternion uv = eiu.times(qv);
        Quaternion uvd = uv.rotateAroundHopfFibre(this.DD, this.q0);
        return new Vector3D(uvd.StereographicProjection());
    }
}

