/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class SteinerRoman
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm.surface.implicit.SteinerRoman.a", 1.6, 1.6, 1.6);

    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double aa = this.a.getValue();
        double xsqr = SteinerRoman.sqr(x);
        double ysqr = SteinerRoman.sqr(y);
        double zsqr = SteinerRoman.sqr(z);
        double aasqr = SteinerRoman.sqr(aa);
        double height = aasqr * aasqr * (xsqr * ysqr + ysqr * zsqr + zsqr * xsqr) - 2.0 * aa * aasqr * x * y * z;
        return height;
    }

    public SteinerRoman() {
        this.addParameter(this.a);
        this.setDefaultWindow(-0.75, 0.75, -0.75, 0.75);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.searchRadius.reset(1.0);
        this.randomLineCount.reset(80000);
        this.pointCloudCount.reset(18000);
        this.level.reset(0.0, 0.0, 0.0);
        this.setFramesForMorphing(12);
        this.resolution = 0.01;
        this.rayTraceResolution.setValue(this.resolution);
        this.heightFunctionType = SurfaceImplicit.equationType.QUARTIC;
    }
}

