/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class CrossCap
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm.surface.implicit.CrossCap.a", 0.17, 0.17, 0.17);

    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double aa = this.a.getValue();
        double xsqr = CrossCap.sqr(x);
        double ysqr = CrossCap.sqr(y);
        double zsqr = CrossCap.sqr(z);
        double aasqr = CrossCap.sqr(aa);
        double height = 4.0 * aasqr * xsqr * (aasqr * (xsqr + ysqr + zsqr) + aa * z) + aasqr * ysqr * (aasqr * (ysqr + zsqr) - 1.0);
        return height;
    }

    public CrossCap() {
        this.addParameter(this.a);
        this.setDefaultWindow(-7.0, 7.0, -7.0, 7.0);
        this.setDefaultViewpoint(new Vector3D(-16.93, -0.137, 3.64));
        this.setDefaultViewUp(new Vector3D(0.21, 0.007, 0.98));
        this.searchRadius.reset(6.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(0.0, 0.0, 0.0);
        this.setFramesForMorphing(12);
        this.heightFunctionType = SurfaceImplicit.equationType.QUARTIC;
    }
}

