/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class CayleyCubic
extends SurfaceImplicit {
    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double xsqr = CayleyCubic.sqr(x);
        double ysqr = CayleyCubic.sqr(y);
        double zsqr = CayleyCubic.sqr(z);
        double height = 4.0 * (xsqr + ysqr + zsqr) + 16.0 * x * y * z;
        return height;
    }

    public CayleyCubic() {
        this.setDefaultWindow(-3.25, 3.25, -3.25, 3.25);
        this.setDefaultViewpoint(new Vector3D(-7.0, -10.0, 10.0));
        this.setDefaultViewUp(new Vector3D(0.3634, 0.5192, 0.774));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(1.0, 0.0, 1.0);
        this.setFramesForMorphing(12);
        this.heightFunctionType = SurfaceImplicit.equationType.CUBIC;
    }
}

