/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;
import vmm.core.ComplexParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.pseudospherical.ComplexMatrix2D;
import vmm.pseudospherical.ComplexVector2D;
import vmm.pseudospherical.nSolitons;

public class Breather
extends nSolitons {
    public ComplexParamAnimateable alpha = new ComplexParamAnimateable("alpha", new Complex(0.6, 0.8), new Complex(1.0, 0.0), new Complex(0.0, 1.0));
    public ComplexVector2D vect = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(2.0, 1.0));
    private ComplexMatrix2D g1_alpha;
    private ComplexMatrix2D g2_alpha;

    public Breather() {
        int j;
        int i;
        this.s.setName("s");
        this.addParameter(this.alpha);
        this.addParameter(this.s);
        this.umin.reset(-4.5);
        this.umax.reset(3.5);
        this.vmin.reset("-3*pi");
        this.vmax.reset("3*pi");
        this.setDefaultWindow(-1.47301, 3.02699, -1.40071, 2.09929);
        this.setDefaultViewpoint(new Vector3D(-3.78115, -6.81146, 1.90246));
        this.setDefaultViewUp(new Vector3D(-0.855955, 0.505503, 0.108658));
        this.lambda = new Complex(0.0, 1.0);
        this.E = new ComplexMatrix2D[2][6];
        for (i = 0; i <= 1; ++i) {
            for (j = 0; j < 6; ++j) {
                this.E[i][j] = new ComplexMatrix2D();
            }
        }
        this.g = new ComplexMatrix2D[2][5];
        for (i = 0; i <= 1; ++i) {
            for (j = 0; j < 5; ++j) {
                this.g[i][j] = new ComplexMatrix2D();
            }
        }
        this.E0 = new ComplexMatrix2D();
        this.getE0(this.xVar, this.s.getValue(), this.lambda);
        this.proj = ComplexMatrix2D.getProj(this.initVec);
        this.id = new ComplexMatrix2D();
        this.id.setMatrixEntry(Complex.ONE_C, 1, 1);
        this.id.setMatrixEntry(Complex.ZERO_C, 1, 2);
        this.id.setMatrixEntry(Complex.ZERO_C, 2, 1);
        this.id.setMatrixEntry(Complex.ONE_C, 2, 2);
        this.g1 = new ComplexMatrix2D();
        this.g1_alpha = this.getG1_alpha(this.lambda, this.alpha.getValue(), this.vect);
        this.g2_alpha = this.getG2_alpha(this.lambda, this.alpha.getValue(), this.vect);
    }

    public ComplexMatrix2D getG1_alpha(Complex lbda, Complex alpha, ComplexVector2D vect) {
        ComplexMatrix2D projection = this.getProj(vect);
        ComplexMatrix2D projPerp = this.id.subtract(projection);
        Complex i = alpha.minus(alpha.conj());
        i = i.dividedBy(lbda.minus(alpha));
        ComplexMatrix2D g = new ComplexMatrix2D();
        g.entries[1][1] = new Complex(i.times(projPerp.entries[1][1]).plus(1.0));
        g.entries[1][2] = new Complex(i.times(projPerp.entries[1][2]));
        g.entries[2][1] = new Complex(i.times(projPerp.entries[2][1]));
        g.entries[2][2] = new Complex(i.times(projPerp.entries[2][2]).plus(1.0));
        return g;
    }

    public ComplexMatrix2D getG2_alpha(Complex lbda, Complex alpha, ComplexVector2D vect) {
        ComplexMatrix2D temp = this.getG1_alpha(Complex.ZERO_C.minus(alpha.conj()), alpha, vect);
        ComplexVector2D vectConj = new ComplexVector2D(vect.x.conj(), vect.y.conj());
        ComplexVector2D w = temp.vectMul(vectConj);
        return this.getG1_alpha(lbda, Complex.ZERO_C.minus(alpha.conj()), w);
    }

    public ComplexMatrix2D compBreather(double x, double t, boolean added) {
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        ComplexMatrix2D h1 = this.getH_alpha(this.lambda, this.alpha.getValue(), this.vect);
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        ComplexMatrix2D h2 = this.getH_alpha(this.lambda, this.alpha.getValue(), this.vect);
        this.lambda = new Complex(1.0, 0.0);
        ComplexMatrix2D h3 = this.getH_alpha(this.lambda, this.alpha.getValue(), this.vect);
        ComplexMatrix2D ret = new ComplexMatrix2D();
        if (!added) {
            this.getE0(x, t, this.alpha.getValue().conj());
            ComplexMatrix2D temp = new ComplexMatrix2D(this.E0.conjugate().transpose());
            ComplexVector2D vectTilde = temp.vectMul(this.vect);
            this.lambda = new Complex(1.0 + this.epsilon, 0.0);
            ComplexMatrix2D g11 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            ComplexMatrix2D g22 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            ComplexMatrix2D h1_tilde = new ComplexMatrix2D(g22.multiply(g11));
            ret = h1.multiply(this.E[0][0]).multiply(h1_tilde.conjugate().transpose());
            this.lambda = new Complex(1.0 - this.epsilon, 0.0);
            g11 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            g22 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            h1_tilde = new ComplexMatrix2D(g22.multiply(g11));
            ret = ret.subtract(h2.multiply(this.E[0][1]).multiply(h1_tilde.conjugate().transpose()));
            ret = ret.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
            this.lambda = new Complex(1.0, 0.0);
            g11 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            g22 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            h1_tilde = new ComplexMatrix2D(g22.multiply(g11));
            ret = ret.multiply(h1_tilde.multiply(this.E[0][2].conjugate().transpose()).multiply(h3.conjugate().transpose()));
        } else {
            this.getE0(x, t, this.alpha.getValue().conj());
            this.getg1(this.alpha.getValue().conj());
            ComplexMatrix2D temp = this.getg1Perp(this.alpha.getValue().conj());
            temp = this.g1.multiply(this.E0).multiply(temp.inverse());
            temp = temp.conjugate().transpose();
            ComplexVector2D vectTilde = temp.vectMul(this.vect);
            this.lambda = new Complex(1.0 + this.epsilon, 0.0);
            ComplexMatrix2D g11 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            ComplexMatrix2D g22 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            ComplexMatrix2D h1_tilde = g22.multiply(g11);
            ret = h1.multiply(this.E[1][0]).multiply(h1_tilde.conjugate().transpose());
            this.lambda = new Complex(1.0 - this.epsilon, 0.0);
            g11 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            g22 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            h1_tilde = g22.multiply(g11);
            ret = ret.subtract(h2.multiply(this.E[1][1]).multiply(h1_tilde.conjugate().transpose()));
            ret = ret.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
            this.lambda = new Complex(1.0, 0.0);
            g11 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            g22 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), vectTilde));
            h1_tilde = g22.multiply(g11);
            ret = ret.multiply(h1_tilde.multiply(this.E[1][2].conjugate().transpose()).multiply(h3.conjugate().transpose()));
        }
        return ret;
    }

    public ComplexMatrix2D getH_alpha(Complex lbda, Complex alpha, ComplexVector2D vect) {
        this.g1_alpha = this.getG1_alpha(lbda, alpha, vect);
        this.g2_alpha = this.getG2_alpha(lbda, alpha, vect);
        return this.g2_alpha.multiply(this.g1_alpha);
    }

    @Override
    public synchronized Vector3D surfacePoint(double x, double t) {
        ComplexMatrix2D ret = this.firstSoliton(x, t);
        ret = this.compBreather(x, t, false);
        double aa = ret.entries[1][1].im;
        double bb = ret.entries[1][2].re;
        double cc = ret.entries[1][2].im;
        if (Double.isNaN(aa) || Double.isNaN(aa) || Double.isNaN(aa)) {
            cc = 0.0;
            bb = 0.0;
            aa = 0.0;
        }
        return new Vector3D(aa, bb, cc);
    }
}

