/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Tractrix
extends DecoratedCurve {
    private RealParamAnimateable aa;
    private int pointCount;
    private double AA;
    double xa;
    double ya;
    double xb;
    double yb;
    double rotx;
    double roty;
    double tx;
    double ty;
    double dt;
    double nn;
    double ex;
    double ey;

    public Tractrix() {
        this.tResolution.setValueAndDefault(150);
        this.aa = new RealParamAnimateable("aa", 1.0, 0.75, 2.0);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(0.01);
        this.tmax.setValueAndDefaultFromString("0.99*pi");
        this.setDefaultWindow(-1.75, 1.75, -1.75, 1.75);
        this.pointCount = 18000;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    @Override
    public double xValue(double t) {
        this.AA = this.aa.getValue();
        return this.AA * Math.sin(t);
    }

    @Override
    public double yValue(double t) {
        return this.AA * (Math.cos(t) + Math.log(Math.tan(t / 2.0)));
    }

    @Override
    public View getDefaultView() {
        DecoratedCurve.MMOView view = (DecoratedCurve.MMOView)super.getDefaultView();
        view.simplifyActionMenu = false;
        view.setUseCloud(false);
        return view;
    }

    private void abbreviations(double t) {
        this.xa = this.xValue(t);
        this.ya = this.yValue(t);
        this.tx = Math.cos(t);
        this.ty = -Math.sin(t) + 1.0 / Math.sin(t);
        this.nn = Math.sqrt(this.tx * this.tx + this.ty * this.ty);
        if (this.nn == 0.0) {
            this.ex = 0.0;
            this.ey = 1.0;
        } else {
            this.ex = -this.ty / this.nn;
            this.ey = this.tx / this.nn;
        }
        this.roty = -this.xa * this.ty / this.tx + this.ya;
        this.rotx = this.xa - (this.roty - this.ya) * this.ty / this.tx;
        this.dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
    }

    @Override
    protected void drawNeededStuff(Graphics2D g, View view, Transform limits, double t) {
        DecoratedCurve.MMOView myView = (DecoratedCurve.MMOView)view;
        Color saveColor = g.getColor();
        this.abbreviations(t);
        myView.setStrokeSizeMultiplier(3);
        g.setColor(Color.red);
        g.draw(new Line2D.Double(this.xa, this.ya, 0.0, this.roty));
        g.setColor(saveColor);
        this.setStrokeSize(3);
        this.setWantedColor(Color.red);
        g.setColor(saveColor);
        if (myView.getUseCloud()) {
            myView.setStrokeSizeMultiplier(1);
            g.setColor(Color.green);
            g.draw(new Line2D.Double(0.0, this.roty, this.rotx, this.roty));
            g.draw(new Line2D.Double(this.xa, this.ya, this.rotx, this.roty));
            g.draw(new Ellipse2D.Double(this.rotx - 0.03, this.roty - 0.03, 0.06, 0.06));
            g.setColor(Color.blue);
            this.abbreviations(t - this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 2.0 * this.AA);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
            this.abbreviations(t + this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 2.0 * this.AA);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
            myView.setStrokeSizeMultiplier(3);
        }
        g.setColor(saveColor);
    }
}

