/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.Animation;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.RealParam;
import vmm.core.TimerAnimation;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.planecurve.PlaneCurve;
import vmm.planecurve.parametric.NormalBundleDecoration;
import vmm.planecurve.parametric.OsculatingCircleAnimation;
import vmm.planecurve.parametric.ParallelCurveAnimation;
import vmm.planecurve.parametric.TangentAndNormalDecoration;

public abstract class PlaneCurveParametric
extends PlaneCurve {
    protected IntegerParam tResolution;
    protected RealParam tmin = new RealParam("vmm.planecurve.parametric.PlaneCurveParameteric.tmin", -5.0);
    protected RealParam tmax = new RealParam("vmm.planecurve.parametric.PlaneCurveParameteric.tmax", 5.0);
    protected double[] tVals;

    public abstract double xValue(double var1);

    public abstract double yValue(double var1);

    public double xDerivativeValue(double t) {
        double dx = 0.001;
        double f1 = this.xValue(t + dx);
        double f2 = this.xValue(t + 2.0 * dx);
        double g1 = this.xValue(t - dx);
        double g2 = this.xValue(t - 2.0 * dx);
        return (8.0 * f1 + g2 - (f2 + 8.0 * g1)) / (12.0 * dx);
    }

    public double yDerivativeValue(double t) {
        double dx = 0.001;
        double f1 = this.yValue(t + dx);
        double f2 = this.yValue(t + 2.0 * dx);
        double g1 = this.yValue(t - dx);
        double g2 = this.yValue(t - 2.0 * dx);
        return (8.0 * f1 + g2 - (f2 + 8.0 * g1)) / (12.0 * dx);
    }

    public double x2ndDerivativeValue(double t) {
        double dx = 0.001;
        double f0 = this.xValue(t);
        double f1 = this.xValue(t + dx);
        double f2 = this.xValue(t + 2.0 * dx);
        double g1 = this.xValue(t - dx);
        double g2 = this.xValue(t - 2.0 * dx);
        return (16.0 * f1 + 16.0 * g1 - 30.0 * f0 - f2 - g2) / (12.0 * dx * dx);
    }

    public double y2ndDerivativeValue(double t) {
        double dx = 0.001;
        double f0 = this.yValue(t);
        double f1 = this.yValue(t + dx);
        double f2 = this.yValue(t + 2.0 * dx);
        double g1 = this.yValue(t - dx);
        double g2 = this.yValue(t - 2.0 * dx);
        return (16.0 * f1 + 16.0 * g1 - 30.0 * f0 - f2 - g2) / (12.0 * dx * dx);
    }

    public PlaneCurveParametric() {
        this.tResolution = new IntegerParam("vmm.planecurve.parametric.PlaneCurveParameteric.tResolution", 100);
        this.tResolution.setMinimumValueForInput(4);
        this.tResolution.setMaximumValueForInput(2000);
        this.addParameter(this.tResolution);
        this.addParameter(this.tmax);
        this.addParameter(this.tmin);
    }

    public int getTResolution() {
        return this.tResolution.getValue();
    }

    public double getT(int index) {
        if (this.tVals == null || index < 0 || index > this.tVals.length) {
            return Double.NaN;
        }
        return this.tVals[index];
    }

    public Point2D[] myCircle(double mx, double my, double rad, int numPoints) {
        Point2D[] circPts = new Point2D[numPoints + 1];
        double s = 0.0;
        for (int i = 0; i <= numPoints; ++i) {
            s = (double)(i * 2) * Math.PI / (double)numPoints;
            circPts[i] = new Point2D.Double(mx + rad * Math.cos(s), my + rad * Math.sin(s));
        }
        return circPts;
    }

    @Override
    protected void makePoints() {
        int i;
        int subintervals = this.tResolution.getValue();
        this.tVals = new double[subintervals + 1];
        this.points = new Point2D[subintervals + 1];
        double t = this.tmin.getValue();
        double dt = (this.tmax.getValue() - t) / (double)subintervals;
        for (i = 0; i <= subintervals; ++i) {
            this.tVals[i] = t + dt * (double)i;
        }
        for (i = 0; i <= subintervals; ++i) {
            double x = this.xValue(this.tVals[i]);
            double y = this.yValue(this.tVals[i]);
            this.points[i] = Double.isNaN(x) || Double.isNaN(y) || Double.isInfinite(x) || Double.isInfinite(y) ? null : new Point2D.Double(x, y);
        }
    }

    @Override
    public void doDraw(Graphics2D g, View view, Transform transform) {
        if (this.points.length == 0) {
            return;
        }
        int pointCt = this.points.length;
        if (view instanceof PlaneCurveParametricView) {
            double fraction = ((PlaneCurveParametricView)view).fractionToDraw;
            if (fraction >= 0.0 && fraction < 1.0) {
                pointCt = (int)(fraction * (double)pointCt);
            }
            if (pointCt == 0) {
                pointCt = 1;
            }
        }
        view.drawCurve(this.points, pointCt);
    }

    @Override
    public Animation getCreateAnimation(final View view) {
        if (view == null || !(view instanceof PlaneCurveParametricView)) {
            return null;
        }
        return new TimerAnimation(50, 20){

            @Override
            protected void drawFrame() {
                ((PlaneCurveParametricView)view).fractionToDraw = (double)this.frameNumber / 50.0;
                PlaneCurveParametric.this.forceRedraw();
            }

            @Override
            public void animationStarting() {
                ((PlaneCurveParametricView)view).fractionToDraw = 0.0;
            }

            @Override
            public void animationEnding() {
                ((PlaneCurveParametricView)view).fractionToDraw = 1.0;
                PlaneCurveParametric.this.forceRedraw();
            }
        };
    }

    @Override
    public View getDefaultView() {
        PlaneCurveParametricView view = new PlaneCurveParametricView();
        view.setShowAxes(true);
        return view;
    }

    @Override
    public ActionList getActionsForView(final View view) {
        ActionList actions = super.getActionsForView(view);
        if (view == null) {
            return actions;
        }
        actions.add(null);
        double[] window = this.getDefaultWindow();
        final double width = Math.max(Math.abs(window[1] - window[0]), Math.abs(window[3] - window[2]));
        actions.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showParallelCurves")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Display display = view.getDisplay();
                display.installAnimation(new ParallelCurveAnimation(view, PlaneCurveParametric.this, false, width, width / 200.0));
            }
        });
        actions.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showParallelCurvesWithNormals")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Display display = view.getDisplay();
                display.installAnimation(new ParallelCurveAnimation(view, PlaneCurveParametric.this, true, width, width / 200.0));
            }
        });
        actions.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showOsculatingCircles")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Display display = view.getDisplay();
                display.installAnimation(new OsculatingCircleAnimation(view, PlaneCurveParametric.this, false, true));
            }
        });
        actions.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showOsculatingCirclesWithNormals")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Display display = view.getDisplay();
                display.installAnimation(new OsculatingCircleAnimation(view, PlaneCurveParametric.this));
            }
        });
        actions.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showTangentsAndNormals")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Display display = view.getDisplay();
                display.installAnimation(new TimerAnimation(PlaneCurveParametric.this.getTResolution(), 40){
                    TangentAndNormalDecoration dec;
                    {
                        this.dec = new TangentAndNormalDecoration();
                    }

                    @Override
                    protected void animationEnding() {
                        view.removeDecoration(this.dec);
                    }

                    @Override
                    protected void animationStarting() {
                        this.dec.setCurve(PlaneCurveParametric.this);
                        view.addDecoration(this.dec);
                    }

                    @Override
                    protected void drawFrame() {
                        this.dec.setIndex(this.getFrameNumber());
                    }
                });
            }
        });
        if (view instanceof PlaneCurveParametricView) {
            actions.add(null);
            actions.add(((PlaneCurveParametricView)view).showEvoluteAction);
        }
        return actions;
    }

    public static class PlaneCurveParametricView
    extends View {
        @VMMSave
        private boolean showEvolute;
        private ToggleAction showEvoluteAction;
        private NormalBundleDecoration evolute;
        double fractionToDraw = -1.0;

        public PlaneCurveParametricView() {
            this.setAntialiased(true);
            this.showEvoluteAction = new ToggleAction(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.DisplayEvolute")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PlaneCurveParametricView.this.setShowEvolute(this.getState());
                }
            };
        }

        public boolean getShowEvolute() {
            return this.showEvolute;
        }

        public void setShowEvolute(boolean showEvolute) {
            if (this.showEvolute == showEvolute) {
                return;
            }
            this.showEvolute = showEvolute;
            this.showEvoluteAction.setState(showEvolute);
            if (showEvolute) {
                this.evolute = new NormalBundleDecoration();
                this.evolute.setShowEvolute(true);
                this.addDecoration(this.evolute);
            } else {
                this.removeDecoration(this.evolute);
                this.evolute = null;
            }
            this.forceRedraw();
        }

        NormalBundleDecoration getEvoluteDecoration() {
            return this.evolute;
        }
    }
}

