/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.Decorateable;
import vmm.core.ThreadedAnimation;
import vmm.planecurve.parametric.NormalBundleDecoration;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class ParallelCurveAnimation
extends ThreadedAnimation {
    private PlaneCurveParametric curve;
    private Decorateable owner;
    private double offsetMax = 10.0;
    private double offsetIncrement = 0.05;
    private boolean showNormals;

    public ParallelCurveAnimation(PlaneCurveParametric curve) {
        this(curve, curve);
    }

    public ParallelCurveAnimation(Decorateable owner, PlaneCurveParametric curve) {
        this.owner = owner != null ? owner : curve;
        this.curve = curve;
    }

    public ParallelCurveAnimation(Decorateable owner, PlaneCurveParametric curve, boolean showNormals, double offsetMax, double offsetIncrement) {
        this.owner = owner != null ? owner : curve;
        this.curve = curve;
        this.showNormals = showNormals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runAnimation() {
        NormalBundleDecoration dec = new NormalBundleDecoration(this.curve);
        dec.setLayer(2);
        this.owner.addDecoration(dec);
        try {
            int points = this.curve.getTResolution();
            if (this.showNormals) {
                for (int i = 1; i <= points + 1; ++i) {
                    dec.setPointCount(i);
                    this.pause(20);
                }
                this.pause(100);
                dec.setPointCount(0);
            }
            dec.setShowEvolute(true);
            this.pause(200);
            for (double offset = 0.0; offset <= this.offsetMax; offset += this.offsetIncrement) {
                dec.setParallelCurveOffset(offset);
                this.pause(50);
            }
        }
        finally {
            this.owner.removeDecoration(dec);
        }
    }
}

