/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.ConicSection;

public class Ellipse
extends ConicSection {
    private RealParamAnimateable verticalRadius = new RealParamAnimateable("vmm.planecurve.parametric.Ellipse.VerticalRadius", 2.0, 1.0, 3.0);
    private RealParamAnimateable horizontalRadius = new RealParamAnimateable("vmm.planecurve.parametric.Ellipse.HorizontalRadius", 3.0, 5.0, 1.0);

    public Ellipse() {
        this.setDefaultWindow(-6.5, 6.5, -6.5, 6.5);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.addParameter(this.verticalRadius);
        this.addParameter(this.horizontalRadius);
    }

    @Override
    public double xValue(double t) {
        return this.horizontalRadius.getValue() * Math.cos(t);
    }

    @Override
    public double yValue(double t) {
        return this.verticalRadius.getValue() * Math.sin(t);
    }

    @Override
    public double xDerivativeValue(double t) {
        return -this.horizontalRadius.getValue() * Math.sin(t);
    }

    @Override
    public double yDerivativeValue(double t) {
        return this.verticalRadius.getValue() * Math.cos(t);
    }

    @Override
    public double x2ndDerivativeValue(double t) {
        return -this.horizontalRadius.getValue() * Math.cos(t);
    }

    @Override
    public double y2ndDerivativeValue(double t) {
        return -this.verticalRadius.getValue() * Math.sin(t);
    }

    @Override
    protected void drawFociAndDirectrix(Graphics2D g, View view, Transform limits, double t) {
        double radius;
        double f1_y;
        double f2_y;
        double f2_x;
        double f1_x;
        double a = this.horizontalRadius.getValue();
        double b = this.verticalRadius.getValue();
        double c = Math.sqrt(Math.abs(a * a - b * b));
        if (a * a > b * b) {
            f1_x = c;
            f2_x = -c;
            f2_y = 0.0;
            f1_y = 0.0;
            radius = 2.0 * Math.abs(a);
        } else {
            f1_y = c;
            f2_y = -c;
            f2_x = 0.0;
            f1_x = 0.0;
            radius = 2.0 * Math.abs(b);
        }
        Color saveColor = g.getColor();
        double width = Math.abs(limits.getXmax() - limits.getXmin());
        double crossSize = 4.0 * limits.getPixelWidth();
        g.setColor(Color.red);
        g.draw(new Line2D.Double(f1_x - crossSize, f1_y - crossSize, f1_x + crossSize, f1_y + crossSize));
        g.draw(new Line2D.Double(f1_x - crossSize, f1_y + crossSize, f1_x + crossSize, f1_y - crossSize));
        g.draw(new Line2D.Double(f2_x - crossSize, f2_y - crossSize, f2_x + crossSize, f2_y + crossSize));
        g.draw(new Line2D.Double(f2_x - crossSize, f2_y + crossSize, f2_x + crossSize, f2_y - crossSize));
        g.setColor(Color.blue);
        g.draw(new Ellipse2D.Double(f2_x - radius, f2_y - radius, 2.0 * radius, 2.0 * radius));
        if (Double.isNaN(t)) {
            g.setColor(saveColor);
            return;
        }
        double x = this.xValue(t);
        double y = this.yValue(t);
        g.setColor(new Color(0, 150, 0));
        double dx = this.xDerivativeValue(t);
        double dy = this.yDerivativeValue(t);
        g.draw(new Line2D.Double(x - width * dx, y - width * dy, x + width * dx, y + width * dy));
        g.setColor(Color.red);
        g.draw(new Line2D.Double(x, y, f2_x, f2_y));
        g.setColor(Color.magenta);
        g.draw(new Line2D.Double(x, y, f1_x, f1_y));
        dx = x - f2_x;
        dy = y - f2_y;
        double length = Math.sqrt(dx * dx + dy * dy);
        double s_x = f2_x + dx / length * radius;
        double s_y = f2_y + dy / length * radius;
        g.draw(new Line2D.Double(x, y, s_x, s_y));
        g.draw(new Line2D.Double(f1_x, f1_y, s_x, s_y));
        view.drawString("F", f1_x + 4.0 * limits.getPixelWidth(), f1_y + 4.0 * limits.getPixelHeight());
        view.drawString("S", s_x + 3.0 * limits.getPixelWidth(), s_y + 2.0 * limits.getPixelHeight());
        g.setColor(saveColor);
    }
}

