/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.secondorder3D;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Util;
import vmm.core.View;
import vmm.core3D.BasicMouseTask3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.ode.ODE_3D;

public abstract class ODE2ndOrder3DNonAutonomous
extends ODE_3D {
    public ODE2ndOrder3DNonAutonomous() {
        super(false, false, "t", "x", "y", "z", "x'", "y'", "z'");
        this.initialDataDefault = new double[]{0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0};
        this.timeSpanDefault = 30.0;
    }

    @Override
    protected void nextEulerPoint(double[] pointData, double dt) {
        double t = pointData[0];
        double x = pointData[1];
        double y = pointData[2];
        double z = pointData[3];
        double xdot = pointData[4];
        double ydot = pointData[5];
        double zdot = pointData[6];
        pointData[0] = t + dt;
        pointData[1] = x + dt * xdot;
        pointData[2] = y + dt * ydot;
        pointData[3] = z + dt * zdot;
        pointData[4] = xdot + dt * this.xdotdot(x, y, z, xdot, ydot, zdot, t);
        pointData[5] = ydot + dt * this.ydotdot(x, y, z, xdot, ydot, zdot, t);
        pointData[6] = zdot + dt * this.zdotdot(x, y, z, xdot, ydot, zdot, t);
    }

    @Override
    protected void nextRungeKuttaPoint(double[] pointData, double dt) {
        double t = pointData[0];
        double x = pointData[1];
        double y = pointData[2];
        double z = pointData[3];
        double xdot = pointData[4];
        double ydot = pointData[5];
        double zdot = pointData[6];
        double i1 = dt * xdot;
        double j1 = dt * ydot;
        double m1 = dt * zdot;
        double h1 = dt * this.xdotdot(x, y, z, xdot, ydot, zdot, t);
        double k1 = dt * this.ydotdot(x, y, z, xdot, ydot, zdot, t);
        double n1 = dt * this.zdotdot(x, y, z, xdot, ydot, zdot, t);
        double i2 = dt * (xdot + h1 / 2.0);
        double j2 = dt * (ydot + k1 / 2.0);
        double m2 = dt * (zdot + n1 / 2.0);
        double h2 = dt * this.xdotdot(x + i1 / 2.0, y + j1 / 2.0, z + m1 / 2.0, xdot + h1 / 2.0, ydot + k1 / 2.0, zdot + n1 / 2.0, t + dt / 2.0);
        double k2 = dt * this.ydotdot(x + i1 / 2.0, y + j1 / 2.0, z + m1 / 2.0, xdot + h1 / 2.0, ydot + k1 / 2.0, zdot + n1 / 2.0, t + dt / 2.0);
        double n2 = dt * this.zdotdot(x + i1 / 2.0, y + j1 / 2.0, z + m1 / 2.0, xdot + h1 / 2.0, ydot + k1 / 2.0, zdot + n1 / 2.0, t + dt / 2.0);
        double i3 = dt * (xdot + h2 / 2.0);
        double j3 = dt * (ydot + k2 / 2.0);
        double m3 = dt * (zdot + n2 / 2.0);
        double h3 = dt * this.xdotdot(x + i2 / 2.0, y + j2 / 2.0, z + m2 / 2.0, xdot + h2 / 2.0, ydot + k2 / 2.0, zdot + n2 / 2.0, t + dt / 2.0);
        double k3 = dt * this.ydotdot(x + i2 / 2.0, y + j2 / 2.0, z + m2 / 2.0, xdot + h2 / 2.0, ydot + k2 / 2.0, zdot + n2 / 2.0, t + dt / 2.0);
        double n3 = dt * this.zdotdot(x + i2 / 2.0, y + j2 / 2.0, z + m2 / 2.0, xdot + h2 / 2.0, ydot + k2 / 2.0, zdot + n2 / 2.0, t + dt / 2.0);
        double i4 = dt * (xdot + h3);
        double j4 = dt * (ydot + k3);
        double m4 = dt * (zdot + n3);
        double h4 = dt * this.xdotdot(x + i3, y + j3, z + m3, xdot + h3, ydot + k3, zdot + n3, t + dt);
        double k4 = dt * this.ydotdot(x + i3, y + j3, z + m3, xdot + h3, ydot + k3, zdot + n3, t + dt);
        double n4 = dt * this.zdotdot(x + i3, y + j3, z + m3, xdot + h3, ydot + k3, zdot + n3, t + dt);
        double dx = i1 / 6.0 + i2 / 3.0 + i3 / 3.0 + i4 / 6.0;
        double dy = j1 / 6.0 + j2 / 3.0 + j3 / 3.0 + j4 / 6.0;
        double dz = m1 / 6.0 + m2 / 3.0 + m3 / 3.0 + m4 / 6.0;
        double dxdot = h1 / 6.0 + h2 / 3.0 + h3 / 3.0 + h4 / 6.0;
        double dydot = k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0;
        double dzdot = n1 / 6.0 + n2 / 3.0 + n3 / 3.0 + n4 / 6.0;
        pointData[0] = t + dt;
        pointData[1] = x + dx;
        pointData[2] = y + dy;
        pointData[3] = z + dz;
        pointData[4] = xdot + dxdot;
        pointData[5] = ydot + dydot;
        pointData[6] = zdot + dzdot;
    }

    protected abstract double xdotdot(double var1, double var3, double var5, double var7, double var9, double var11, double var13);

    protected abstract double ydotdot(double var1, double var3, double var5, double var7, double var9, double var11, double var13);

    protected abstract double zdotdot(double var1, double var3, double var5, double var7, double var9, double var11, double var13);

    @Override
    protected MouseTask makeDefaultMouseTask(ODE_3D.ODEView view) {
        return new ThrowIt();
    }

    private class ThrowIt
    extends BasicMouseTask3D {
        int startX;
        int startY;
        int currentX;
        int currentY;
        boolean throwing;

        private ThrowIt() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            if (evt.isAltDown()) {
                this.throwing = true;
                this.startX = this.currentX = evt.getX();
                this.startY = this.currentY = evt.getY();
                return true;
            }
            return super.doMouseDown(evt, display, view, width, height);
        }

        @Override
        public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
            if (this.throwing) {
                this.currentX = evt.getX();
                this.currentY = evt.getY();
                view.forceRedraw();
            } else {
                super.doMouseDrag(evt, display, view, width, height);
            }
        }

        @Override
        public void doMouseUp(MouseEvent evt, Display display, View view, int width, int height) {
            if (this.throwing) {
                this.throwing = false;
                ODE_3D.ODEView odeView = (ODE_3D.ODEView)view;
                double t = odeView.getCurrentTimeFromControlPanel();
                Vector3D pt1 = ODE2ndOrder3DNonAutonomous.this.screenPointTo3DPoint(odeView, this.startX, this.startY);
                Vector3D pt2 = ODE2ndOrder3DNonAutonomous.this.screenPointTo3DPoint(odeView, this.currentX, this.currentY);
                double[] data = new double[]{t, pt1.x, pt1.y, pt1.z, pt2.x - pt1.x, pt2.y - pt1.y, pt2.z - pt1.z};
                ((ODE_3D.ODEView)view).startOrbitAtPoint(data);
            } else {
                super.doMouseUp(evt, display, view, width, height);
            }
        }

        @Override
        public void drawWhileDragging(Graphics2D g, Display display, View view, int width, int height) {
            if (this.throwing) {
                if (((View3D)view).getViewStyle() == 1) {
                    g.setColor(Color.YELLOW);
                } else {
                    g.setColor(view.getForeground());
                }
                g.drawLine(this.startX, this.startY, this.currentX, this.currentY);
            } else {
                super.drawWhileDragging(g, display, view, width, height);
            }
        }

        @Override
        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText");
        }
    }
}

