/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.firstorder3D;

import java.awt.event.MouseEvent;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Util;
import vmm.core.View;
import vmm.core3D.BasicMouseTask3D;
import vmm.core3D.Vector3D;
import vmm.ode.ODE_3D;

public abstract class ODE1stOrder3DNonAutonomous
extends ODE_3D {
    protected abstract double xPrime(double var1, double var3, double var5, double var7);

    protected abstract double yPrime(double var1, double var3, double var5, double var7);

    protected abstract double zPrime(double var1, double var3, double var5, double var7);

    @Override
    protected void nextEulerPoint(double[] pointData, double dt) {
        double t = pointData[0];
        double x = pointData[1];
        double y = pointData[2];
        double z = pointData[3];
        double dx = dt * this.xPrime(x, y, z, t);
        double dy = dt * this.yPrime(x, y, z, t);
        double dz = dt * this.zPrime(x, y, z, t);
        pointData[0] = t + dt;
        pointData[1] = x + dx;
        pointData[2] = y + dy;
        pointData[3] = z + dz;
    }

    @Override
    protected void nextRungeKuttaPoint(double[] pointData, double dt) {
        double t = pointData[0];
        double x = pointData[1];
        double y = pointData[2];
        double z = pointData[3];
        double h1 = dt * this.xPrime(x, y, z, t);
        double k1 = dt * this.yPrime(x, y, z, t);
        double j1 = dt * this.zPrime(x, y, z, t);
        double h2 = dt * this.xPrime(x + h1 / 2.0, y + k1 / 2.0, z + j1 / 2.0, t + dt / 2.0);
        double k2 = dt * this.yPrime(x + h1 / 2.0, y + k1 / 2.0, z + j1 / 2.0, t + dt / 2.0);
        double j2 = dt * this.zPrime(x + h1 / 2.0, y + k1 / 2.0, z + j1 / 2.0, t + dt / 2.0);
        double h3 = dt * this.xPrime(x + h2 / 2.0, y + k2 / 2.0, z + j2 / 2.0, t + dt / 2.0);
        double k3 = dt * this.yPrime(x + h2 / 2.0, y + k2 / 2.0, z + j2 / 2.0, t + dt / 2.0);
        double j3 = dt * this.zPrime(x + h2 / 2.0, y + k2 / 2.0, z + j2 / 2.0, t + dt / 2.0);
        double h4 = dt * this.xPrime(x + h3, y + k3, z + j3, t + dt);
        double k4 = dt * this.yPrime(x + h3, y + k3, z + j3, t + dt);
        double j4 = dt * this.zPrime(x + h3, y + k3, z + j3, t + dt);
        double dx = h1 / 6.0 + h2 / 3.0 + h3 / 3.0 + h4 / 6.0;
        double dy = k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0;
        double dz = j1 / 6.0 + j2 / 3.0 + j3 / 3.0 + j4 / 4.0;
        pointData[0] = t + dt;
        pointData[1] = x + dx;
        pointData[2] = y + dy;
        pointData[3] = z + dz;
    }

    public ODE1stOrder3DNonAutonomous() {
        super(false, false, "t", "x", "y", "z");
        this.initialDataDefault = new double[]{0.0, 1.0, 1.0, 1.0};
    }

    @Override
    protected MouseTask makeDefaultMouseTask(ODE_3D.ODEView view) {
        return new StartOrbit();
    }

    private class StartOrbit
    extends BasicMouseTask3D {
        private StartOrbit() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            if (evt.isAltDown()) {
                ODE_3D.ODEView odeView = (ODE_3D.ODEView)view;
                double t = odeView.getCurrentTimeFromControlPanel();
                Vector3D pt = ODE1stOrder3DNonAutonomous.this.screenPointTo3DPoint(odeView, evt.getX(), evt.getY());
                if (pt != null) {
                    odeView.startOrbitAtPoint(new double[]{t, pt.x, pt.y, pt.z});
                }
                return false;
            }
            return super.doMouseDown(evt, display, view, width, height);
        }

        @Override
        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText");
        }
    }
}

