/*
 * Decompiled with CFR 0.152.
 */
package vmm.functions;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import vmm.core.I18n;
import vmm.functions.ComplexExpression;
import vmm.functions.ComplexFunction;
import vmm.functions.ComplexFunction1;
import vmm.functions.ComplexFunction2;
import vmm.functions.ComplexFunction3;
import vmm.functions.ComplexVariable;
import vmm.functions.Expression;
import vmm.functions.Function;
import vmm.functions.Function1;
import vmm.functions.Function2;
import vmm.functions.Function3;
import vmm.functions.ParseError;
import vmm.functions.ProgFunction;
import vmm.functions.StackOp;
import vmm.functions.StandardFunction;
import vmm.functions.Type;
import vmm.functions.Variable;

public class Parser {
    private static Variable PI = new Variable("pi", Math.PI);
    private static Variable E = new Variable("e", Math.E);
    private static ComplexVariable I = new ComplexVariable("i", 0.0, 1.0);
    private static EnumSet<Token> relationalOps = EnumSet.of(Token.EQUAL, new Token[]{Token.NOT_EQUAL, Token.GREATER, Token.GREATER_EQUAL, Token.LESS, Token.LESS_EQUAL});
    private static EnumSet<Token> canStartFactor = EnumSet.of(Token.NUMBER, new Token[]{Token.VARIABLE, Token.COMPLEX_VARIABLE, Token.ARGUMENT, Token.COMPLEX_ARGUMENT, Token.FUNCTION, Token.COMPLEX_FUNCTION, Token.STANDARD_FUNCTION, Token.FUNCTION_COMPLEX_TO_REAL, Token.LEFT_BRACE, Token.LEFT_PAREN, Token.LEFT_BRACKET, Token.TIMES, Token.DIVIDE});
    private static EnumSet<StackOp> needRealToComplex = EnumSet.of(StackOp.SQRT, new StackOp[]{StackOp.CUBERT, StackOp.LOG, StackOp.LOG2, StackOp.LOG10, StackOp.ARCSIN, StackOp.ARCCOS, StackOp.ARCTAN, StackOp.ARCSINH, StackOp.ARCCOSH, StackOp.ARCTANH});
    private SymbolTable symbolTable;

    public Parser() {
        this(null);
    }

    public Parser(Parser parent) {
        if (parent != null) {
            this.symbolTable = new SymbolTable(parent.symbolTable);
        } else {
            StandardFunction[] functions;
            this.symbolTable = new SymbolTable();
            this.add(PI);
            this.add(E);
            this.add(I);
            for (StandardFunction f : functions = StandardFunction.getFunctions()) {
                this.symbolTable.put(f.getName().toLowerCase(), f);
            }
        }
    }

    public Expression parse(String str) {
        return this.parseExpression(str);
    }

    public Expression parseExpression(String str) {
        Context context = new Context(str, this.symbolTable, false);
        context.bldr.start(0, Type.REAL);
        Type type = this.doParse(context);
        if (type == Type.COMPLEX) {
            this.error(context, "vmm.parser.ExpectedRealFoundComplex", new Object[0]);
        }
        if (type == Type.BOOLEAN) {
            this.error(context, "vmm.parser.ExpectedRealFoundBoolean", new Object[0]);
        }
        return new Expression(context.bldr.finish(Type.REAL));
    }

    public Function1 parseFunction1(String name, String definition, String argumentName) {
        return (Function1)this.parseFunction(name, definition, argumentName);
    }

    public Function2 parseFunction2(String name, String definition, String argumentName1, String argumentName2) {
        return (Function2)this.parseFunction(name, definition, argumentName1, argumentName2);
    }

    public Function3 parseFunction3(String name, String definition, String argumentName1, String argumentName2, String argumentName3) {
        return (Function3)this.parseFunction(name, definition, argumentName1, argumentName2, argumentName3);
    }

    public Function parseFunction(String name, String definition, String ... argumentName) {
        Context context;
        int argCount;
        if (argumentName != null && argumentName.length > 0) {
            argCount = argumentName.length;
            SymbolTable tbl = new SymbolTable(this.symbolTable);
            for (int i = 0; i < argumentName.length; ++i) {
                tbl.put(argumentName[i].toLowerCase(), new Argument(i));
            }
            context = new Context(definition, tbl, false);
        } else {
            argCount = 0;
            context = new Context(definition, this.symbolTable, false);
        }
        context.bldr.start(argCount, Type.REAL);
        Type type = this.doParse(context);
        if (type == Type.COMPLEX) {
            this.error(context, "vmm.parser.ExpectedRealFoundComplex", new Object[0]);
        }
        if (type == Type.BOOLEAN) {
            this.error(context, "vmm.parser.ExpectedRealFoundBoolean", new Object[0]);
        }
        ProgFunction func = context.bldr.finish(Type.REAL);
        if (argCount == 1) {
            return new Function1(name, func);
        }
        if (argCount == 2) {
            return new Function2(name, func);
        }
        if (argCount == 3) {
            return new Function3(name, func);
        }
        return new Function(name, func);
    }

    public ComplexExpression parseComplexExpression(String str) {
        Context context = new Context(str, this.symbolTable, true);
        context.bldr.start(0, Type.COMPLEX);
        Type type = this.doParse(context);
        if (type == Type.BOOLEAN) {
            this.error(context, "vmm.parser.ExpectedCompplexFoundBoolean", new Object[0]);
        }
        if (type == Type.REAL) {
            context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
        }
        return new ComplexExpression(context.bldr.finish(Type.COMPLEX));
    }

    public ComplexFunction1 parseComplexFunction1(String name, String definition, String argumentName) {
        return (ComplexFunction1)this.parseComplexFunction(name, definition, argumentName);
    }

    public ComplexFunction2 parseComplexFunction2(String name, String definition, String argumentName1, String argumentName2) {
        return (ComplexFunction2)this.parseComplexFunction(name, definition, argumentName1, argumentName2);
    }

    public ComplexFunction3 parseComplexFunction3(String name, String definition, String argumentName1, String argumentName2, String argumentName3) {
        return (ComplexFunction3)this.parseComplexFunction(name, definition, argumentName1, argumentName2, argumentName3);
    }

    public ComplexFunction parseComplexFunction(String name, String definition, String ... argumentName) {
        Context context;
        int argCount;
        if (argumentName != null && argumentName.length > 0) {
            argCount = argumentName.length;
            SymbolTable tbl = new SymbolTable(this.symbolTable);
            for (int i = 0; i < argumentName.length; ++i) {
                tbl.put(argumentName[i].toLowerCase(), new ComplexArgument(i));
            }
            context = new Context(definition, tbl, false);
        } else {
            argCount = 0;
            context = new Context(definition, this.symbolTable, true);
        }
        context.bldr.start(argCount, Type.COMPLEX);
        Type type = this.doParse(context);
        if (type == Type.BOOLEAN) {
            this.error(context, "vmm.parser.ExpectedCompplexFoundBoolean", new Object[0]);
        }
        if (type == Type.REAL) {
            context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
        }
        ProgFunction func = context.bldr.finish(Type.COMPLEX);
        if (argCount == 1) {
            return new ComplexFunction1(name, func);
        }
        if (argCount == 2) {
            return new ComplexFunction2(name, func);
        }
        if (argCount == 3) {
            return new ComplexFunction3(name, func);
        }
        return new ComplexFunction(name, func);
    }

    public void add(Variable v) {
        this.symbolTable.put(v.getName().toLowerCase(), v);
    }

    public void add(ComplexVariable v) {
        this.symbolTable.put(v.getName().toLowerCase(), v);
    }

    public void add(Function f) {
        this.symbolTable.put(f.getName().toLowerCase(), f);
    }

    public void add(ComplexFunction f) {
        this.symbolTable.put(f.getName().toLowerCase(), f);
    }

    public Object get(String name) {
        return this.symbolTable.get(name.toLowerCase());
    }

    public void remove(String objectName) {
        this.symbolTable.remove(objectName.toLowerCase());
    }

    private void error(Context context, String errorMessage, Object ... arg) {
        String err = I18n.tr(errorMessage);
        if (arg != null && arg.length > 0) {
            err = MessageFormat.format(err, arg);
        }
        context.bldr.reset();
        throw new ParseError(err, context.pos, context.str);
    }

    private Type doParse(Context cntx) {
        if (cntx.peek() == Token.EOS) {
            this.error(cntx, "vmm.parser.EmpytDefinition", new Object[0]);
        }
        Type type = this.parseBExpr(cntx);
        if (cntx.peek() != Token.EOS) {
            this.error(cntx, "vmm.parser.ExtraStuff", new Object[0]);
        }
        return type;
    }

    private Type parseBExpr(Context cntx) {
        Type type = this.parseBTerm(cntx);
        while (cntx.peek() == Token.OR) {
            if (type != Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequriesBoolean", "OR");
            }
            cntx.next();
            Type nextType = this.parseBTerm(cntx);
            if (nextType != Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequriesBoolean", "OR");
            }
            cntx.bldr.addStackOp(StackOp.OR);
        }
        if (cntx.peek() == Token.QUESTION) {
            Type nextType;
            if (type != Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.ConditionalRequiresBoolean", new Object[0]);
            }
            cntx.next();
            int firstExpr = cntx.bldr.startSubProg();
            type = this.parseNumericalExpr(cntx);
            if (type == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.ConditionalExpressionsMustBeNumerical", new Object[0]);
            }
            cntx.bldr.finishSubProg();
            int secondExpr = cntx.bldr.startSubProg();
            if (cntx.peek() != Token.COLON) {
                nextType = type;
                if (type == Type.REAL) {
                    cntx.bldr.addRealConstant(Double.NaN);
                } else {
                    cntx.bldr.addComplexConstant(Double.NaN, Double.NaN);
                }
            } else {
                cntx.next();
                nextType = this.parseBExpr(cntx);
                if (nextType == Type.BOOLEAN) {
                    this.error(cntx, "vmm.parser.ConditionalExpressionsMustBeNumerical", new Object[0]);
                }
                if (type == Type.COMPLEX && nextType == Type.REAL) {
                    cntx.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
                }
            }
            cntx.bldr.finishSubProg();
            if (type == Type.REAL && nextType == Type.COMPLEX) {
                cntx.bldr.addConditional(firstExpr, secondExpr, true);
                type = Type.COMPLEX;
            } else {
                cntx.bldr.addConditional(firstExpr, secondExpr, false);
            }
        }
        return type;
    }

    private Type parseBTerm(Context cntx) {
        Type type = this.parseBFactor(cntx);
        while (cntx.peek() == Token.AND) {
            if (type != Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequriesBoolean", "AND");
            }
            cntx.next();
            Type nextType = this.parseBFactor(cntx);
            if (nextType != Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequriesBoolean", "AND");
            }
            cntx.bldr.addStackOp(StackOp.AND);
        }
        return type;
    }

    private Type parseBFactor(Context cntx) {
        int notCount = 0;
        while (cntx.peek() == Token.NOT) {
            ++notCount;
            cntx.next();
        }
        Type type = this.parseRelation(cntx);
        if (notCount > 0 && type != Type.BOOLEAN) {
            this.error(cntx, "vmm.parser.OperatorRequriesBoolean", "NOT");
        }
        if (notCount % 2 == 1) {
            cntx.bldr.addStackOp(StackOp.NOT);
        }
        return type;
    }

    private Type parseRelation(Context cntx) {
        Type type = this.parseNumericalExpr(cntx);
        if (relationalOps.contains((Object)cntx.peek())) {
            Type nextType;
            Token op = cntx.next();
            String opName = cntx.tokstr;
            if (type == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequiresNumerical", opName);
            }
            if (type == Type.COMPLEX && op != Token.EQUAL && op != Token.NOT_EQUAL) {
                this.error(cntx, "vmm.parser.RelationNotDefinedForComplex", opName);
            }
            if ((nextType = this.parseNumericalExpr(cntx)) == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequiresNumerical", opName);
            }
            if (nextType == Type.COMPLEX && op != Token.EQUAL && op != Token.NOT_EQUAL) {
                this.error(cntx, "vmm.parser.RelationNotDefinedForComplex", opName);
            }
            if (type == Type.REAL && nextType == Type.COMPLEX) {
                cntx.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                type = Type.COMPLEX;
            }
            switch (op) {
                case EQUAL: {
                    cntx.bldr.addStackOp(type == Type.COMPLEX ? StackOp.C_EQ : StackOp.EQ);
                    break;
                }
                case NOT_EQUAL: {
                    cntx.bldr.addStackOp(type == Type.COMPLEX ? StackOp.C_NE : StackOp.NE);
                    break;
                }
                case GREATER: {
                    cntx.bldr.addStackOp(StackOp.GT);
                    break;
                }
                case LESS: {
                    cntx.bldr.addStackOp(StackOp.LT);
                    break;
                }
                case GREATER_EQUAL: {
                    cntx.bldr.addStackOp(StackOp.GE);
                    break;
                }
                case LESS_EQUAL: {
                    cntx.bldr.addStackOp(StackOp.LE);
                }
            }
            if (relationalOps.contains((Object)cntx.peek())) {
                this.error(cntx, "vmm.parser.CantStringRelations", new Object[0]);
            }
            return Type.BOOLEAN;
        }
        return type;
    }

    private Type parseNumericalExpr(Context cntx) {
        Token leadingSign = null;
        if (cntx.peek() == Token.PLUS || cntx.peek() == Token.MINUS) {
            leadingSign = cntx.next();
        }
        Type type = this.parseNumericalTerm(cntx);
        if (leadingSign != null) {
            if (type == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequiresNumerical", leadingSign == Token.PLUS ? "+" : "-");
            }
            if (leadingSign == Token.MINUS) {
                cntx.bldr.addStackOp(type == Type.REAL ? StackOp.UNARY_MINUS : StackOp.C_UNARY_MINUS);
            }
        }
        while (cntx.peek() == Token.PLUS || cntx.peek() == Token.MINUS) {
            Type nextType;
            Token op = cntx.next();
            String opName = cntx.tokstr;
            if (type == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequiresNumerical", opName);
            }
            if ((nextType = this.parseNumericalTerm(cntx)) == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequiresNumerical", opName);
            }
            if (type == Type.REAL && nextType == Type.COMPLEX) {
                cntx.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                type = Type.COMPLEX;
            } else if (type == Type.COMPLEX && nextType == Type.REAL) {
                cntx.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
            }
            if (type == Type.REAL) {
                cntx.bldr.addStackOp(op == Token.PLUS ? StackOp.PLUS : StackOp.MINUS);
                continue;
            }
            cntx.bldr.addStackOp(op == Token.PLUS ? StackOp.C_PLUS : StackOp.C_MINUS);
        }
        return type;
    }

    private Type parseNumericalTerm(Context cntx) {
        Type type = this.parseNumericalFactor(cntx);
        while (canStartFactor.contains((Object)cntx.peek())) {
            Type nextType;
            String opName;
            Token op;
            if (cntx.peek() == Token.TIMES || cntx.peek() == Token.DIVIDE) {
                op = cntx.next();
                opName = cntx.tokstr;
            } else {
                op = Token.TIMES;
                opName = "*";
            }
            if (type == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequiresNumerical", opName);
            }
            if ((nextType = this.parseNumericalFactor(cntx)) == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequiresNumerical", opName);
            }
            if (type == Type.REAL && nextType == Type.COMPLEX) {
                cntx.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                type = Type.COMPLEX;
            } else if (type == Type.COMPLEX && nextType == Type.REAL) {
                cntx.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
            }
            if (type == Type.REAL) {
                cntx.bldr.addStackOp(op == Token.TIMES ? StackOp.TIMES : StackOp.DIVIDE);
                continue;
            }
            cntx.bldr.addStackOp(op == Token.TIMES ? StackOp.C_TIMES : StackOp.C_DIVIDE);
        }
        return type;
    }

    private Type parseNumericalFactor(Context cntx) {
        Type type = this.parseNumericalPrimary(cntx);
        while (cntx.peek() == Token.POWER) {
            Type nextType;
            cntx.next();
            String opName = cntx.tokstr;
            if (type == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequiresNumerical", opName);
            }
            if ((nextType = this.parseNumericalPrimary(cntx)) == Type.BOOLEAN) {
                this.error(cntx, "vmm.parser.OperatorRequiresNumerical", opName);
            }
            if (type == Type.REAL) {
                if (nextType == Type.COMPLEX) {
                    cntx.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                    type = Type.COMPLEX;
                } else if (cntx.complexOnly) {
                    cntx.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
                    cntx.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                    type = nextType = Type.COMPLEX;
                }
            }
            if (type == Type.COMPLEX && nextType == Type.REAL) {
                cntx.bldr.addStackOp(StackOp.C_REAL_POWER);
                continue;
            }
            if (type == Type.REAL) {
                cntx.bldr.addStackOp(StackOp.POWER);
                continue;
            }
            cntx.bldr.addStackOp(StackOp.C_POWER);
        }
        return type;
    }

    private Type parseNumericalPrimary(Context cntx) {
        Token tok = cntx.next();
        switch (tok) {
            case NUMBER: {
                cntx.bldr.addRealConstant(cntx.number);
                return Type.REAL;
            }
            case VARIABLE: {
                cntx.bldr.addVariableRef((Variable)cntx.symbol);
                return Type.REAL;
            }
            case ARGUMENT: {
                cntx.bldr.addArgumentReference(((Argument)cntx.symbol).argnum);
                return Type.REAL;
            }
            case COMPLEX_VARIABLE: {
                cntx.bldr.addComplexVariableRef((ComplexVariable)cntx.symbol);
                return Type.COMPLEX;
            }
            case COMPLEX_ARGUMENT: {
                cntx.bldr.addArgumentReference(((ComplexArgument)cntx.symbol).argnum);
                return Type.COMPLEX;
            }
            case FUNCTION: 
            case COMPLEX_FUNCTION: 
            case STANDARD_FUNCTION: 
            case FUNCTION_COMPLEX_TO_REAL: {
                StandardFunction f;
                Token funcTok = tok;
                Object symbol = cntx.symbol;
                String funcName = cntx.tokstr;
                Token openingParen = cntx.next();
                if (openingParen != Token.LEFT_PAREN && openingParen != Token.LEFT_BRACE && openingParen != Token.LEFT_BRACKET) {
                    this.error(cntx, "vmm.parser.FunctionRequiresParen", funcName);
                }
                int argCount = 0;
                int expectedArgs = funcTok == Token.FUNCTION ? ((Function)symbol).getArity() : (funcTok == Token.COMPLEX_FUNCTION ? ((ComplexFunction)symbol).getArity() : (funcTok == Token.STANDARD_FUNCTION ? 1 : 2));
                Type argType = null;
                while ((tok = cntx.peek()) != Token.RIGHT_PAREN && tok != Token.RIGHT_BRACE && tok != Token.RIGHT_BRACKET) {
                    if (++argCount > expectedArgs) {
                        this.error(cntx, "vmm.parser.TooManyArguments", funcName);
                    }
                    argType = this.parseBExpr(cntx);
                    if (funcTok == Token.FUNCTION || funcTok == Token.FUNCTION_COMPLEX_TO_REAL) {
                        if (argType != Type.REAL) {
                            this.error(cntx, "vmm.parser.NeedRealArgument", funcName);
                        }
                    } else if (funcTok == Token.COMPLEX_FUNCTION) {
                        if (argType == Type.BOOLEAN) {
                            this.error(cntx, "vmm.parser.NeedComplexArgument", funcName);
                        }
                        if (argType == Type.REAL) {
                            cntx.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
                        }
                    } else if (funcTok == Token.STANDARD_FUNCTION) {
                        f = (StandardFunction)symbol;
                        if (argType == Type.COMPLEX) {
                            if (f.getComplexArgOp() == null) {
                                this.error(cntx, "vmm.parser.NeedRealArgument", funcName);
                            }
                        } else if (argType == Type.REAL) {
                            if (f.getRealArgOp() == null || cntx.complexOnly && needRealToComplex.contains((Object)f.getRealArgOp())) {
                                cntx.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
                                argType = Type.COMPLEX;
                            }
                        } else if (f.getRealArgOp() == null || cntx.complexOnly && needRealToComplex.contains((Object)f.getRealArgOp())) {
                            this.error(cntx, "vmm.parser.NeedComplexArgument", funcName);
                        } else {
                            this.error(cntx, "vmm.parser.NeedRealArgument", funcName);
                        }
                    }
                    if ((tok = cntx.peek()) != Token.COMMA) break;
                    cntx.next();
                }
                tok = cntx.next();
                if (argCount < expectedArgs) {
                    this.error(cntx, "vmm.parser.NotEnoughArguments", funcName);
                }
                if (openingParen == Token.LEFT_PAREN && tok != Token.RIGHT_PAREN) {
                    this.error(cntx, "vmm.parser.MissingCloseOfArgumentList", ")");
                }
                if (openingParen == Token.LEFT_BRACE && tok != Token.RIGHT_BRACE) {
                    this.error(cntx, "vmm.parser.MissingCloseOfArgumentList", "}");
                }
                if (openingParen == Token.LEFT_BRACKET && tok != Token.RIGHT_BRACKET) {
                    this.error(cntx, "vmm.parser.MissingCloseOfArgumentList", "]");
                }
                if (funcTok == Token.FUNCTION) {
                    cntx.bldr.addFunctionRef(((Function)symbol).getProgFunction());
                    return Type.REAL;
                }
                if (funcTok == Token.COMPLEX_FUNCTION) {
                    cntx.bldr.addFunctionRef(((ComplexFunction)symbol).getProgFunction());
                    return Type.COMPLEX;
                }
                if (funcTok == Token.FUNCTION_COMPLEX_TO_REAL) {
                    return Type.COMPLEX;
                }
                f = (StandardFunction)symbol;
                cntx.bldr.addStackOp(argType == Type.COMPLEX ? f.getComplexArgOp() : f.getRealArgOp());
                return argType == Type.COMPLEX ? f.getReturnTypeForComplexArg() : f.getReturnTypeForRealArg();
            }
            case LEFT_PAREN: {
                Type type = this.parseBExpr(cntx);
                tok = cntx.next();
                if (tok == Token.EOS) {
                    this.error(cntx, "vmm.parser.MissingRightGroupThingAtEOS", ")", "(");
                }
                if (tok != Token.RIGHT_PAREN) {
                    this.error(cntx, "vmm.parser.MissingRightGroupThing", ")", "(", cntx.tokstr);
                }
                return type;
            }
            case LEFT_BRACE: {
                Type type = this.parseBExpr(cntx);
                tok = cntx.next();
                if (tok == Token.EOS) {
                    this.error(cntx, "vmm.parser.MissingRightGroupThingAtEOS", "]", "[");
                }
                if (tok != Token.RIGHT_BRACE) {
                    this.error(cntx, "vmm.parser.MissingRightGroupThing", "]", "[", cntx.tokstr);
                }
                return type;
            }
            case LEFT_BRACKET: {
                Type type = this.parseBExpr(cntx);
                tok = cntx.next();
                if (tok == Token.EOS) {
                    this.error(cntx, "vmm.parser.MissingRightGroupThingAtEOS", "}", "{");
                }
                if (tok != Token.RIGHT_PAREN) {
                    this.error(cntx, "vmm.parser.MissingRightGroupThing", "}", "{", cntx.tokstr);
                }
                return type;
            }
            case RIGHT_PAREN: {
                this.error(cntx, "vmm.parser.ExtraRightGroupThing", ")", "(");
                return null;
            }
            case RIGHT_BRACE: {
                this.error(cntx, "vmm.parser.ExtraRightGroupThing", "}", "{");
                return null;
            }
            case RIGHT_BRACKET: {
                this.error(cntx, "vmm.parser.ExtraRightGroupThing", "]", "[");
                return null;
            }
            case UNKNOWN_CHAR: {
                this.error(cntx, "vmm.parser.UnknownChar", cntx.tokstr);
                return null;
            }
            case UNKNOWN_WORD: {
                this.error(cntx, "vmm.parser.UndefinedWord", cntx.tokstr);
                return null;
            }
            case ILLEGAL_NUMBER: {
                this.error(cntx, "vmm.parser.IllegalNumber", cntx.tokstr);
                return null;
            }
            case EOS: {
                this.error(cntx, "vmm.parser.IncompleteExpression", new Object[0]);
            }
        }
        this.error(cntx, "vmm.parser.UnexcpectedToken", cntx.tokstr);
        return null;
    }

    private static class ComplexArgument {
        int argnum;

        ComplexArgument(int n) {
            this.argnum = n;
        }
    }

    private static class Argument {
        int argnum;

        Argument(int n) {
            this.argnum = n;
        }
    }

    private static class SymbolTable {
        private SymbolTable parent;
        private HashMap<String, Object> table = new HashMap();

        SymbolTable() {
        }

        SymbolTable(SymbolTable parent) {
            this.parent = parent;
        }

        void put(String name, Object val) {
            this.table.put(name, val);
        }

        void remove(String name) {
            if (name != null) {
                this.table.remove(name.toLowerCase());
            }
        }

        Object get(String name) {
            Object val = this.table.get(name);
            if (val == null && this.parent != null) {
                return this.parent.get(name);
            }
            return val;
        }
    }

    private static class Context {
        private static final Pattern numberRegex = Pattern.compile("(\\+|-)?(([0-9]+(\\.[0-9]*)?)|(\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?");
        private Matcher numberMatcher;
        private SymbolTable symbolTable;
        private Token currentToken;
        ProgFunction.Builder bldr;
        boolean complexOnly;
        Object symbol;
        String str;
        int pos;
        double number;
        String tokstr;

        Context(String str, SymbolTable table, boolean complexOnly) {
            this.str = str;
            this.pos = 0;
            this.symbolTable = table;
            this.complexOnly = complexOnly;
            this.bldr = new ProgFunction.Builder();
        }

        Token peek() {
            if (this.currentToken == null) {
                this.currentToken = this.readToken();
            }
            return this.currentToken;
        }

        Token next() {
            Token t = this.peek();
            this.currentToken = null;
            return t;
        }

        private Token readToken() {
            this.symbol = null;
            if (this.str == null) {
                return Token.EOS;
            }
            while (this.pos < this.str.length() && Character.isWhitespace(this.str.charAt(this.pos))) {
                ++this.pos;
            }
            if (this.pos >= this.str.length()) {
                return Token.EOS;
            }
            char ch = this.str.charAt(this.pos);
            if (Character.isLetter(ch) || ch == '_') {
                this.tokstr = "";
                while (this.pos < this.str.length() && (Character.isLetterOrDigit(this.str.charAt(this.pos)) || this.str.charAt(this.pos) == '_')) {
                    this.tokstr = this.tokstr + this.str.charAt(this.pos);
                    ++this.pos;
                }
                while (this.pos < this.str.length() && this.str.charAt(this.pos) == '\'') {
                    this.tokstr = this.tokstr + '\'';
                    ++this.pos;
                }
                String lower = this.tokstr.toLowerCase();
                this.symbol = this.symbolTable.get(lower);
                if (this.symbol != null) {
                    if (this.symbol instanceof Variable) {
                        return Token.VARIABLE;
                    }
                    if (this.symbol instanceof ComplexVariable) {
                        return Token.COMPLEX_VARIABLE;
                    }
                    if (this.symbol instanceof Function) {
                        return Token.FUNCTION;
                    }
                    if (this.symbol instanceof ComplexFunction) {
                        return Token.COMPLEX_FUNCTION;
                    }
                    if (this.symbol instanceof Argument) {
                        return Token.ARGUMENT;
                    }
                    if (this.symbol instanceof ComplexArgument) {
                        return Token.COMPLEX_ARGUMENT;
                    }
                    if (this.symbol instanceof StandardFunction) {
                        return Token.STANDARD_FUNCTION;
                    }
                    throw new IllegalStateException("internal error: unknown object type in symbol table");
                }
                if (lower.equals("complex")) {
                    return Token.FUNCTION_COMPLEX_TO_REAL;
                }
                if (lower.equals("and")) {
                    return Token.AND;
                }
                if (lower.equals("or")) {
                    return Token.OR;
                }
                if (lower.equals("not")) {
                    return Token.NOT;
                }
                return Token.UNKNOWN_WORD;
            }
            if (Character.isDigit(ch) || ch == '.') {
                if (this.numberMatcher == null) {
                    this.numberMatcher = numberRegex.matcher(this.str);
                }
                this.numberMatcher.region(this.pos, this.str.length());
                if (this.numberMatcher.lookingAt()) {
                    this.tokstr = this.numberMatcher.group();
                    this.pos = this.numberMatcher.end();
                    try {
                        this.number = Double.parseDouble(this.tokstr);
                        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e) {
                        return Token.ILLEGAL_NUMBER;
                    }
                    return Token.NUMBER;
                }
                ++this.pos;
                this.tokstr = ".";
                return Token.ILLEGAL_NUMBER;
            }
            if (ch == '=') {
                this.tokstr = "=";
                ++this.pos;
                if (this.pos == this.str.length()) {
                    return Token.EQUAL;
                }
                if (this.str.charAt(this.pos) == '=') {
                    this.tokstr = this.tokstr + '=';
                    ++this.pos;
                    return Token.EQUAL;
                }
                if (this.str.charAt(this.pos) == '>') {
                    this.tokstr = this.tokstr + '>';
                    ++this.pos;
                    return Token.GREATER_EQUAL;
                }
                if (this.str.charAt(this.pos) == '<') {
                    this.tokstr = this.tokstr + '<';
                    ++this.pos;
                    return Token.LESS_EQUAL;
                }
                return Token.EQUAL;
            }
            if (ch == '<') {
                this.tokstr = "<";
                ++this.pos;
                if (this.pos == this.str.length()) {
                    return Token.LESS;
                }
                if (this.str.charAt(this.pos) == '=') {
                    ++this.pos;
                    this.tokstr = this.tokstr + '=';
                    return Token.LESS_EQUAL;
                }
                if (this.str.charAt(this.pos) == '>') {
                    ++this.pos;
                    this.tokstr = this.tokstr + '>';
                    return Token.NOT_EQUAL;
                }
                return Token.LESS;
            }
            if (ch == '>') {
                this.tokstr = ">";
                ++this.pos;
                if (this.pos == this.str.length()) {
                    return Token.GREATER;
                }
                if (this.str.charAt(this.pos) == '=') {
                    this.tokstr = this.tokstr + '=';
                    ++this.pos;
                    return Token.GREATER_EQUAL;
                }
                if (this.str.charAt(this.pos) == '>') {
                    this.tokstr = this.tokstr + '>';
                    ++this.pos;
                    return Token.NOT_EQUAL;
                }
                return Token.GREATER;
            }
            if (ch == '!') {
                this.tokstr = "!";
                ++this.pos;
                if (this.pos < this.str.length() && this.str.charAt(this.pos) == '=') {
                    this.tokstr = this.tokstr + '=';
                    ++this.pos;
                    return Token.NOT_EQUAL;
                }
                return Token.UNKNOWN_CHAR;
            }
            if (ch == '*') {
                this.tokstr = "*";
                ++this.pos;
                if (this.pos < this.str.length() && this.str.charAt(this.pos) == '*') {
                    this.tokstr = this.tokstr + '*';
                    ++this.pos;
                    return Token.POWER;
                }
                return Token.TIMES;
            }
            if (ch == '&') {
                this.tokstr = "&";
                ++this.pos;
                if (this.pos < this.str.length() && this.str.charAt(this.pos) == '&') {
                    this.tokstr = this.tokstr + '&';
                    ++this.pos;
                }
                return Token.AND;
            }
            if (ch == '|') {
                this.tokstr = "|";
                ++this.pos;
                if (this.pos < this.str.length() && this.str.charAt(this.pos) == '|') {
                    this.tokstr = this.tokstr + '|';
                    ++this.pos;
                }
                return Token.OR;
            }
            this.tokstr = "" + ch;
            ++this.pos;
            switch (ch) {
                case '(': {
                    return Token.LEFT_PAREN;
                }
                case ')': {
                    return Token.RIGHT_PAREN;
                }
                case '{': {
                    return Token.LEFT_BRACE;
                }
                case '}': {
                    return Token.RIGHT_BRACE;
                }
                case '[': {
                    return Token.LEFT_BRACKET;
                }
                case ']': {
                    return Token.RIGHT_BRACKET;
                }
                case '?': {
                    return Token.QUESTION;
                }
                case ':': {
                    return Token.COLON;
                }
                case ',': {
                    return Token.COMMA;
                }
                case '+': {
                    return Token.PLUS;
                }
                case '-': {
                    return Token.MINUS;
                }
                case '/': {
                    return Token.DIVIDE;
                }
                case '^': {
                    return Token.POWER;
                }
                case '~': {
                    return Token.NOT;
                }
            }
            return Token.UNKNOWN_CHAR;
        }
    }

    private static enum Token {
        NUMBER,
        ILLEGAL_NUMBER,
        FUNCTION,
        COMPLEX_FUNCTION,
        STANDARD_FUNCTION,
        FUNCTION_COMPLEX_TO_REAL,
        VARIABLE,
        COMPLEX_VARIABLE,
        ARGUMENT,
        COMPLEX_ARGUMENT,
        UNKNOWN_WORD,
        LEFT_PAREN,
        RIGHT_PAREN,
        LEFT_BRACE,
        RIGHT_BRACE,
        LEFT_BRACKET,
        RIGHT_BRACKET,
        PLUS,
        MINUS,
        TIMES,
        DIVIDE,
        POWER,
        AND,
        OR,
        NOT,
        EQUAL,
        NOT_EQUAL,
        GREATER,
        LESS,
        GREATER_EQUAL,
        LESS_EQUAL,
        QUESTION,
        COLON,
        COMMA,
        UNKNOWN_CHAR,
        EOS;

    }
}

