/*
 * Decompiled with CFR 0.152.
 */
package vmm.functions;

import vmm.core.Complex;
import vmm.functions.ComplexFunction;
import vmm.functions.EvalStack;
import vmm.functions.ProgFunction;
import vmm.functions.Type;

public class ComplexFunction1
extends ComplexFunction {
    ComplexFunction1(String name, ProgFunction func) {
        super(name, func);
        assert (func.getArgType() == Type.COMPLEX && func.getType() == Type.COMPLEX && func.getArgCount() == 1);
    }

    public synchronized Complex value(Complex z) {
        return this.value(z, EvalStack.perThread());
    }

    public synchronized Complex value(double z_re, double z_im) {
        return this.value(z_re, z_im, EvalStack.perThread());
    }

    public Complex value(Complex z, EvalStack stack) {
        Complex answer = new Complex();
        this.value(z, stack, answer);
        return answer;
    }

    public Complex value(double z_re, double z_im, EvalStack stack) {
        Complex answer = new Complex();
        this.value(z_re, z_im, stack, answer);
        return answer;
    }

    public void value(Complex z, EvalStack stack, Complex answer) {
        if (answer == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        stack.push(z);
        this.func.apply(stack);
        stack.popComplex(answer);
    }

    public void value(double z_re, double z_im, EvalStack stack, Complex answer) {
        if (answer == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        stack.push(z_re, z_im);
        this.func.apply(stack);
        stack.popComplex(answer);
    }
}

