/*
 * Decompiled with CFR 0.152.
 */
package vmm.fourier;

import vmm.core.Complex;
import vmm.fourier.FastFourier;

public class FourierSeries {
    static final int SAMPLINGARRAYSIZE = 1025;
    private static Complex[] SamplingArray;
    private static Complex[] SamplingArrayTransform;

    public static boolean IsAPowerOf2(int N) {
        return N == 4 || N == 8 || N == 16 || N == 32 || N == 64 || N == 128 || N == 256 || N == 512;
    }

    private static void InitializeSamplingArrays() {
        int i;
        if (SamplingArray == null) {
            SamplingArray = new Complex[1025];
            for (i = 0; i < 1025; ++i) {
                FourierSeries.SamplingArray[i] = new Complex();
            }
        }
        if (SamplingArrayTransform == null) {
            SamplingArrayTransform = new Complex[1025];
            for (i = 0; i < 1025; ++i) {
                FourierSeries.SamplingArrayTransform[i] = new Complex();
            }
        }
    }

    private static Complex eToThe2piIalpha(double alpha) {
        return Complex.I_C.times(Math.PI * 2 * alpha).exponential();
    }

    public static void SFT(Complex[] f, Complex[] G, int N) {
        int k;
        if (G == null) {
            G = new Complex[N];
            for (k = 0; k < N; ++k) {
                G[k] = new Complex();
            }
        }
        for (k = 0; k < N; ++k) {
            G[k] = Complex.ZERO_C;
            for (int j = 0; j < N; ++j) {
                double alpha = (double)(-j * k) / (double)N;
                G[k] = G[k].plus(f[j].times(FourierSeries.eToThe2piIalpha(alpha)));
                G[k] = G[k].times(1 / N);
            }
        }
    }

    public static void ISFT(Complex[] G, Complex[] f, int N) {
        int k;
        if (f == null) {
            f = new Complex[N];
            for (k = 0; k < N; ++k) {
                f[k] = new Complex();
            }
        }
        for (k = 0; k < N; ++k) {
            f[k] = Complex.ZERO_C;
            for (int j = 0; j < N; ++j) {
                double alpha = (double)(-j * k) / (double)N;
                f[k] = f[k].plus(G[j].times(FourierSeries.eToThe2piIalpha(alpha)));
            }
        }
    }

    public static void DFT(Complex[] f, Complex[] G, int N) {
        if (G == null) {
            G = new Complex[N];
            for (int k = 0; k < N; ++k) {
                G[k] = new Complex();
            }
        }
        if (N == 4 || N == 8 || N == 16 || N == 32 || N == 64 || N == 128 || N == 256 || N == 512) {
            for (int i = 0; i < N; ++i) {
                G[i] = f[i];
            }
            FastFourier.fft(G, N);
        } else {
            FourierSeries.SFT(f, G, N);
        }
    }

    public static void IDFT(Complex[] G, Complex[] f, int N) {
        if (f == null) {
            f = new Complex[N];
            for (int k = 0; k < N; ++k) {
                f[k] = new Complex();
            }
        }
        if (N == 4 || N == 8 || N == 16 || N == 32 || N == 64 || N == 128 || N == 256 || N == 512) {
            for (int i = 0; i < N; ++i) {
                f[i] = G[i];
            }
            FastFourier.ifft(f, N);
        } else {
            FourierSeries.ISFT(G, f, N);
        }
    }

    public static void DFTinPlace(Complex[] f, int N) {
        FourierSeries.InitializeSamplingArrays();
        if (N == 4 || N == 8 || N == 16 || N == 32 || N == 64 || N == 128 || N == 256 || N == 512) {
            FastFourier.fft(f, N);
        } else {
            FourierSeries.SFT(f, SamplingArrayTransform, N);
            for (int i = 0; i < N; ++i) {
                f[i] = SamplingArrayTransform[i];
            }
        }
    }

    public static void IDFTinPlace(Complex[] G, int N) {
        FourierSeries.InitializeSamplingArrays();
        if (N == 4 || N == 8 || N == 16 || N == 32 || N == 64 || N == 128 || N == 256 || N == 512) {
            FastFourier.ifft(G, N);
        } else {
            FourierSeries.ISFT(G, SamplingArray, N);
            for (int i = 0; i < N; ++i) {
                G[i] = SamplingArray[i];
            }
        }
    }

    public static void DST(double[] f, double[] G, int N) {
        int i;
        FourierSeries.InitializeSamplingArrays();
        for (i = 0; i < N; ++i) {
            f[2 * N - i] = -f[i];
        }
        for (i = 0; i < 2 * N; ++i) {
            FourierSeries.SamplingArray[i].re = f[i];
            FourierSeries.SamplingArray[i].im = 0.0;
        }
        FourierSeries.DFTinPlace(SamplingArray, 2 * N);
        for (i = 0; i < N; ++i) {
            G[i] = 0.5 * FourierSeries.SamplingArray[i].im;
        }
    }

    public static void IDST(double[] G, double[] f, int N) {
        double TwoOverN = 2.0 / (double)N;
        FourierSeries.DST(f, G, N);
        for (int i = 0; i < N; ++i) {
            G[i] = TwoOverN * G[i];
        }
    }

    public static void DSTinPlace(double[] f, int N) {
        int i;
        FourierSeries.InitializeSamplingArrays();
        for (i = 0; i < N; ++i) {
            f[2 * N - i] = -f[i];
        }
        for (i = 1; i <= 2 * N; ++i) {
            FourierSeries.SamplingArray[i].re = f[i];
            FourierSeries.SamplingArray[i].im = 0.0;
        }
        FourierSeries.DFTinPlace(SamplingArray, 2 * N);
        for (i = 1; i <= N; ++i) {
            f[i] = 0.5 * FourierSeries.SamplingArray[i].im;
        }
    }

    public static void IDSTinPlace(double[] f, int N) {
        double TwoOverN = 2.0 / (double)N;
        FourierSeries.DSTinPlace(f, N);
        for (int i = 0; i < N; ++i) {
            f[i] = TwoOverN * f[i];
        }
    }
}

