/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.core.I18n;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Grid3D;
import vmm.core3D.SetTransparencyDialog;
import vmm.core3D.Vector3D;
import vmm.core3D.View3DWithLightSettings;

public class View3DLit
extends View3DWithLightSettings {
    public static final int WIREFRAME_RENDERING = 0;
    public static final int PATCH_RENDERING = 1;
    public static final int NORMAL_ORIENTATION = 0;
    public static final int REVERSE_ORIENTATION = 1;
    public static final int NO_ORIENTATION = 2;
    @VMMSave
    private int renderingStyle = 1;
    @VMMSave
    private int orientation = 0;
    @VMMSave
    private boolean phongShading;
    @VMMSave
    private boolean blackAndWhite;
    @VMMSave
    private double transparency;
    private boolean dragAsSurface;
    protected ActionRadioGroup selectRenderingCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.Wireframe"), I18n.tr("vmm.core3D.commands.PatchRendering")}, 1){

        @Override
        public void optionSelected(int selectedIndex) {
            View3DLit.this.setRenderingStyle(selectedIndex);
        }
    };
    protected ActionRadioGroup selectOrientationCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.NormalOrientation"), I18n.tr("vmm.core3D.commands.ReverseOrientation"), I18n.tr("vmm.core3D.commands.NoOrientation")}, 0){

        @Override
        public void optionSelected(int selectedIndex) {
            View3DLit.this.setOrientation(selectedIndex);
        }
    };
    protected ActionRadioGroup selectShadingCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.PhongShading"), I18n.tr("vmm.core3D.commands.FlatShading")}, 0){

        @Override
        public void optionSelected(int selectedIndex) {
            View3DLit.this.setPhongShading(selectedIndex == 0);
        }
    };
    protected ActionRadioGroup selectColoredCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.Color"), I18n.tr("vmm.core3D.commands.BlackAndWhite")}, 0){

        @Override
        public void optionSelected(int selectedIndex) {
            View3DLit.this.setBlackAndWhite(selectedIndex == 1);
        }
    };
    protected ToggleAction dragAsSurfaceToggle = new ToggleAction(I18n.tr("vmm.core3D.commands.DragAsSurface")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            View3DLit.this.setDragAsSurface(this.getState());
        }
    };
    protected AbstractActionVMM setTransparencyCommand = new AbstractActionVMM(I18n.tr("vmm.core3D.commands.setTransparency") + "..."){

        @Override
        public void actionPerformed(ActionEvent evt) {
            SetTransparencyDialog.showDialog(View3DLit.this);
        }
    };

    public View3DLit() {
        this.setOrientation(0);
    }

    public int getRenderingStyle() {
        return this.renderingStyle;
    }

    public void setRenderingStyle(int style) {
        if (style != 0 && style != 1) {
            return;
        }
        this.selectRenderingCommands.setSelectedIndex(style);
        if (this.dragAsSurfaceToggle != null) {
            this.dragAsSurfaceToggle.setEnabled(style == 1);
        }
        if (style == this.renderingStyle) {
            return;
        }
        this.renderingStyle = style;
        this.forceRedraw();
    }

    public boolean getBlackAndWhite() {
        return this.blackAndWhite;
    }

    public void setBlackAndWhite(boolean blackAndWhite) {
        this.selectColoredCommands.setSelectedIndex(blackAndWhite ? 1 : 0);
        if (blackAndWhite != this.blackAndWhite) {
            this.blackAndWhite = blackAndWhite;
            this.offscreenImageType = blackAndWhite ? 10 : 1;
            this.rightStereographOSI = null;
            this.leftStereographOSI = null;
            this.fullOSI = null;
            this.forceRedraw();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1 && orientation != 2) {
            return;
        }
        this.selectOrientationCommands.setSelectedIndex(orientation);
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.forceRedraw();
        }
    }

    public boolean getPhongShading() {
        return this.phongShading;
    }

    public void setPhongShading(boolean phongShading) {
        this.selectShadingCommands.setSelectedIndex(phongShading ? 0 : 1);
        if (this.phongShading != phongShading) {
            this.phongShading = phongShading;
            this.forceRedraw();
        }
    }

    public boolean getDragAsSurface() {
        return this.dragAsSurface;
    }

    public void setDragAsSurface(boolean dragAsSurface) {
        this.dragAsSurfaceToggle.setState(dragAsSurface);
        this.dragAsSurface = dragAsSurface;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        if (transparency < 0.0) {
            transparency = 0.0;
        } else if (transparency > 1.0) {
            transparency = 1.0;
        }
        if (this.transparency == transparency) {
            return;
        }
        this.transparency = transparency;
        this.forceRedraw();
    }

    @Override
    public void setEnableThreeD(boolean enable) {
        if (enable == this.getEnableThreeD()) {
            return;
        }
        super.setEnableThreeD(enable);
        this.selectColoredCommands.setEnabled(enable);
        this.selectOrientationCommands.setEnabled(enable);
        this.selectRenderingCommands.setEnabled(enable);
        this.selectShadingCommands.setEnabled(enable);
        this.dragAsSurfaceToggle.setEnabled(enable);
        this.lightingEnabledToggle.setEnabled(enable);
        if (this.lightSettingsCommand != null) {
            this.lightSettingsCommand.setEnabled(enable);
        }
    }

    @Override
    public ActionList getSettingsCommands() {
        ActionList commands = super.getSettingsCommands();
        commands.add(null);
        commands.add(this.setTransparencyCommand);
        commands.add(null);
        commands.add(this.dragAsSurfaceToggle);
        return commands;
    }

    @Override
    public void setViewStyle(int style) {
        super.setViewStyle(style);
        this.selectColoredCommands.setEnabled(this.getViewStyle() != 1);
    }

    @Override
    public void takeExhibit(View view, boolean shareTransform) {
        super.takeExhibit(view, shareTransform);
        if (view instanceof View3DLit) {
            this.setOrientation(((View3DLit)view).getOrientation());
        }
    }

    @Override
    public ActionList getViewCommands() {
        ActionList commands = super.getViewCommands();
        commands.add(null);
        commands.add(this.selectRenderingCommands);
        commands.add(null);
        commands.add(this.selectColoredCommands);
        this.selectColoredCommands.setEnabled(this.getViewStyle() != 1);
        commands.add(null);
        commands.add(this.selectOrientationCommands);
        return commands;
    }

    public void drawSurface(Grid3D surfaceData) {
        this.drawSurface(surfaceData, 0.0, 1.0);
    }

    public void drawSurface(Grid3D surfaceData, double startPercent, double endPercent) {
        if (this.renderingStyle == 0 || this.getFastDrawing() && !this.dragAsSurface) {
            if (this.getViewStyle() == 0) {
                surfaceData.applyTransform(this.transform3D, this);
                surfaceData.drawCurves(this, this.currentGraphics);
            } else {
                this.setUpForLeftEye();
                surfaceData.applyTransform(this.transform3D, this);
                surfaceData.drawCurves(this, this.currentGraphics);
                this.setUpForRightEye();
                surfaceData.applyTransform(this.transform3D, this);
                surfaceData.drawCurves(this, this.currentGraphics);
                this.finishStereoView();
            }
        } else if (this.renderingStyle == 1) {
            if (this.getViewStyle() == 0) {
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                surfaceData.applyTransform(this.transform3D, this);
                if (this.getFastDrawing()) {
                    surfaceData.drawMajorPatches(this, this.currentGraphics);
                } else {
                    surfaceData.drawSubPatches(this, this.currentGraphics, startPercent, endPercent);
                }
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
            } else {
                this.setUpForLeftEye();
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                surfaceData.applyTransform(this.transform3D, this);
                if (this.getFastDrawing()) {
                    surfaceData.drawMajorPatches(this, this.currentGraphics);
                } else {
                    surfaceData.drawSubPatches(this, this.currentGraphics, startPercent, endPercent);
                }
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.setUpForRightEye();
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                surfaceData.applyTransform(this.transform3D, this);
                if (this.getFastDrawing()) {
                    surfaceData.drawMajorPatches(this, this.currentGraphics);
                } else {
                    surfaceData.drawSubPatches(this, this.currentGraphics, startPercent, endPercent);
                }
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.finishStereoView();
            }
        }
    }

    public void fillPolygon(Vector3D[] vertices, Color outlineColor) {
        if (this.getViewStyle() == 0) {
            Color saveColor = this.currentGraphics.getColor();
            GeneralPath path = new GeneralPath();
            Point2D pt = this.transform3D.objectToDrawingCoords(vertices[0]);
            path.moveTo((float)pt.getX(), (float)pt.getY());
            for (int i = 1; i < vertices.length; ++i) {
                pt = this.transform3D.objectToDrawingCoords(vertices[i]);
                path.lineTo((float)pt.getX(), (float)pt.getY());
            }
            path.closePath();
            this.currentGraphics.fill(path);
            if (outlineColor != null) {
                this.currentGraphics.setColor(outlineColor);
            }
            this.currentGraphics.draw(path);
            this.currentGraphics.setColor(saveColor);
        } else {
            int i;
            this.setUpForLeftEye();
            Color saveColor = this.currentGraphics.getColor();
            GeneralPath path = new GeneralPath();
            Point2D pt = this.transform3D.objectToDrawingCoords(vertices[0]);
            path.moveTo((float)pt.getX(), (float)pt.getY());
            for (i = 1; i < vertices.length; ++i) {
                pt = this.transform3D.objectToDrawingCoords(vertices[i]);
                path.lineTo((float)pt.getX(), (float)pt.getY());
            }
            path.closePath();
            this.currentGraphics.fill(path);
            if (outlineColor != null) {
                this.currentGraphics.setColor(outlineColor);
            }
            this.currentGraphics.draw(path);
            this.currentGraphics.setColor(saveColor);
            this.setUpForRightEye();
            saveColor = this.currentGraphics.getColor();
            path.reset();
            pt = this.transform3D.objectToDrawingCoords(vertices[0]);
            path.moveTo((float)pt.getX(), (float)pt.getY());
            for (i = 1; i < vertices.length; ++i) {
                pt = this.transform3D.objectToDrawingCoords(vertices[i]);
                path.lineTo((float)pt.getX(), (float)pt.getY());
            }
            path.closePath();
            this.currentGraphics.fill(path);
            if (outlineColor != null) {
                this.currentGraphics.setColor(outlineColor);
            }
            this.currentGraphics.draw(path);
            this.currentGraphics.setColor(saveColor);
            this.finishStereoView();
        }
    }
}

