/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.ParameterInput;
import vmm.core.RealParam;
import vmm.core.SettingsDialog;
import vmm.core3D.DirectionalLight;
import vmm.core3D.LightSettings;
import vmm.core3D.Vector3D;
import vmm.core3D.View3DWithLightSettings;

public class LightSettingsDialog
extends SettingsDialog {
    private RealParam[][] colorParams = new RealParam[5][3];
    private RealParam[][] directionParams = new RealParam[3][3];
    private RealParam specularRatioParam;
    private IntegerParam specularExponentParam;
    private ParameterInput[][] colorInputs = new ParameterInput[5][3];
    private ParameterInput[][] directionInputs = new ParameterInput[3][3];
    private ParameterInput specularRatioInput;
    private ParameterInput specularExponentInput;
    private JButton[] colorSetButton = new JButton[5];
    private JButton[] defaultSettingsButton = new JButton[4];
    private LightSettings currentSettings;
    private View3DWithLightSettings owner;
    private ActionListener colorSetter = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            for (int i = 0; i < 5; ++i) {
                if (src != LightSettingsDialog.this.colorSetButton[i]) continue;
                Color c = Color.white;
                try {
                    c = new Color((float)LightSettingsDialog.this.colorParams[i][0].getValue(), (float)LightSettingsDialog.this.colorParams[i][1].getValue(), (float)LightSettingsDialog.this.colorParams[i][2].getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                c = JColorChooser.showDialog(LightSettingsDialog.this, I18n.tr("vmm.core3D.LightSettingsDialog.ColorDialogTitle"), c);
                if (c == null) {
                    return;
                }
                double r = (double)c.getRed() / 255.0;
                double g = (double)c.getGreen() / 255.0;
                double b = (double)c.getBlue() / 255.0;
                r = (double)((int)(r * 100000.0 + 0.499)) / 100000.0;
                g = (double)((int)(g * 100000.0 + 0.499)) / 100000.0;
                b = (double)((int)(b * 100000.0 + 0.499)) / 100000.0;
                LightSettingsDialog.this.colorInputs[i][0].setText("" + r);
                LightSettingsDialog.this.colorInputs[i][1].setText("" + g);
                LightSettingsDialog.this.colorInputs[i][2].setText("" + b);
                return;
            }
        }
    };
    private ActionListener defaultsListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            for (int i = 0; i < 4; ++i) {
                LightSettings newSettings;
                if (src != LightSettingsDialog.this.defaultSettingsButton[i]) continue;
                switch (i) {
                    case 1: {
                        newSettings = new LightSettings(2);
                        break;
                    }
                    case 2: {
                        newSettings = new LightSettings(1);
                        break;
                    }
                    case 3: {
                        newSettings = new LightSettings(3);
                        break;
                    }
                    default: {
                        newSettings = new LightSettings();
                    }
                }
                LightSettingsDialog.this.colorInputs[0][0].setText("" + (double)((int)((double)newSettings.getLight0().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[0][1].setText("" + (double)((int)((double)newSettings.getLight0().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[0][2].setText("" + (double)((int)((double)newSettings.getLight0().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[1][0].setText("" + (double)((int)((double)newSettings.getDirectionalLight1().getItsColor().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[1][1].setText("" + (double)((int)((double)newSettings.getDirectionalLight1().getItsColor().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[1][2].setText("" + (double)((int)((double)newSettings.getDirectionalLight1().getItsColor().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[2][0].setText("" + (double)((int)((double)newSettings.getDirectionalLight2().getItsColor().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[2][1].setText("" + (double)((int)((double)newSettings.getDirectionalLight2().getItsColor().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[2][2].setText("" + (double)((int)((double)newSettings.getDirectionalLight2().getItsColor().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[3][0].setText("" + (double)((int)((double)newSettings.getDirectionalLight3().getItsColor().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[3][1].setText("" + (double)((int)((double)newSettings.getDirectionalLight3().getItsColor().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[3][2].setText("" + (double)((int)((double)newSettings.getDirectionalLight3().getItsColor().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[4][0].setText("" + (double)((int)((double)newSettings.getAmbientLight().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[4][1].setText("" + (double)((int)((double)newSettings.getAmbientLight().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[4][2].setText("" + (double)((int)((double)newSettings.getAmbientLight().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[0][0].setText("" + (double)((int)(newSettings.getDirectionalLight1().getItsDirection().x * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[0][1].setText("" + (double)((int)(newSettings.getDirectionalLight1().getItsDirection().y * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[0][2].setText("" + (double)((int)(newSettings.getDirectionalLight1().getItsDirection().z * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[1][0].setText("" + (double)((int)(newSettings.getDirectionalLight2().getItsDirection().x * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[1][1].setText("" + (double)((int)(newSettings.getDirectionalLight2().getItsDirection().y * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[1][2].setText("" + (double)((int)(newSettings.getDirectionalLight2().getItsDirection().z * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[2][0].setText("" + (double)((int)(newSettings.getDirectionalLight3().getItsDirection().x * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[2][1].setText("" + (double)((int)(newSettings.getDirectionalLight3().getItsDirection().y * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[2][2].setText("" + (double)((int)(newSettings.getDirectionalLight3().getItsDirection().z * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.specularRatioInput.setText("" + (double)((int)((double)(newSettings.getSpecularRatio() * 10000.0f) + 0.5)) / 10000.0);
                LightSettingsDialog.this.specularExponentInput.setText("" + newSettings.getSpecularExponent());
            }
        }
    };

    public static void showDialog(View3DWithLightSettings view) {
        new LightSettingsDialog(view).setVisible(true);
    }

    public LightSettingsDialog(View3DWithLightSettings view) {
        super(view.getDisplay(), I18n.tr("vmm.core3D.LightSettingsDialog.dialogTitle"), false, true);
        int j;
        int i;
        this.owner = view;
        this.currentSettings = view.getLightSettings();
        LightSettings defaultSettings = new LightSettings();
        Box panel = Box.createVerticalBox();
        JPanel colorPanel = this.borderedPanel(I18n.tr("vmm.core3D.LightSettingsDialog.LightColors"), 6, 5);
        JPanel directionPanel = this.borderedPanel(I18n.tr("vmm.core3D.LightSettingsDialog.LightDirections"), 4, 4);
        JPanel specularPanel = this.borderedPanel(I18n.tr("vmm.core3D.LightSettingsDialog.Specular"), 1, 4);
        JPanel defaultsPanel = this.borderedPanel(I18n.tr("vmm.core3D.LightSettingsDialog.DefaultsButtons"), 0, 2);
        panel.add(colorPanel);
        panel.add(directionPanel);
        panel.add(specularPanel);
        panel.add(defaultsPanel);
        String[] names = new String[]{I18n.tr("vmm.core3D.LightSettingsDialog.Source0"), I18n.tr("vmm.core3D.LightSettingsDialog.Source1"), I18n.tr("vmm.core3D.LightSettingsDialog.Source2"), I18n.tr("vmm.core3D.LightSettingsDialog.Source3"), I18n.tr("vmm.core3D.LightSettingsDialog.Ambient")};
        String[] colorNames = new String[]{I18n.tr("common.Red"), I18n.tr("common.Green"), I18n.tr("common.Blue")};
        Vector3D[] currentDirections = new Vector3D[]{this.currentSettings.getDirectionalLight1().getItsDirection(), this.currentSettings.getDirectionalLight2().getItsDirection(), this.currentSettings.getDirectionalLight3().getItsDirection()};
        Vector3D[] defaultDirections = new Vector3D[]{defaultSettings.getDirectionalLight1().getItsDirection(), defaultSettings.getDirectionalLight2().getItsDirection(), defaultSettings.getDirectionalLight3().getItsDirection()};
        colorPanel.add(new JLabel());
        colorPanel.add(new JLabel(colorNames[0], 0));
        colorPanel.add(new JLabel(colorNames[1], 0));
        colorPanel.add(new JLabel(colorNames[2], 0));
        colorPanel.add(new JLabel());
        for (i = 0; i < 5; ++i) {
            colorPanel.add(new JLabel(names[i], 4));
            for (j = 0; j < 3; ++j) {
                this.colorParams[i][j] = new RealParam(names[i] + " " + colorNames[j], this.colorComponent(this.currentSettings, i, j));
                this.colorParams[i][j].setDefaultValue((double)((int)(100000.0 * this.colorComponent(defaultSettings, i, j) + 0.4999)) / 100000.0);
                this.colorParams[i][j].setMinimumValueForInput(0.0);
                this.colorParams[i][j].setMaximumValueForInput(1.0);
                this.colorInputs[i][j] = new ParameterInput(this.colorParams[i][j]);
                this.colorInputs[i][j].setColumns(7);
                colorPanel.add(this.colorInputs[i][j]);
            }
            this.colorSetButton[i] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.SetColorButton"));
            this.colorSetButton[i].addActionListener(this.colorSetter);
            colorPanel.add(this.colorSetButton[i]);
        }
        directionPanel.add(new JLabel());
        directionPanel.add(new JLabel("x", 0));
        directionPanel.add(new JLabel("y", 0));
        directionPanel.add(new JLabel("z", 0));
        for (i = 0; i < 3; ++i) {
            directionPanel.add(new JLabel(names[i + 1], 4));
            this.directionParams[i][0] = new RealParam(names[i + 1] + " x", currentDirections[i].x);
            this.directionParams[i][0].setDefaultValue((double)((int)(100000.0 * defaultDirections[i].x + 0.4999)) / 100000.0);
            this.directionParams[i][1] = new RealParam(names[i + 1] + " y", currentDirections[i].y);
            this.directionParams[i][1].setDefaultValue((double)((int)(100000.0 * defaultDirections[i].y + 0.4999)) / 100000.0);
            this.directionParams[i][2] = new RealParam(names[i + 1] + " z", currentDirections[i].z);
            this.directionParams[i][2].setDefaultValue((double)((int)(100000.0 * defaultDirections[i].z + 0.4999)) / 100000.0);
            for (j = 0; j < 3; ++j) {
                this.directionInputs[i][j] = new ParameterInput(this.directionParams[i][j]);
                this.directionInputs[i][j].setColumns(7);
                directionPanel.add(this.directionInputs[i][j]);
            }
        }
        specularPanel.add(new JLabel(I18n.tr("vmm.core3D.LightSettingsDialog.Ratio"), 4));
        this.specularRatioParam = new RealParam("vmm.core3D.LightSettingsDialog.SpecularRatio", this.currentSettings.getSpecularRatio());
        this.specularRatioParam.setDefaultValue((double)((int)((double)(100000.0f * defaultSettings.getSpecularRatio()) + 0.4999)) / 100000.0);
        this.specularRatioParam.setMinimumValueForInput(0.0);
        this.specularRatioParam.setMaximumValueForInput(1.0);
        this.specularRatioInput = new ParameterInput(this.specularRatioParam);
        this.specularRatioInput.setColumns(7);
        specularPanel.add(this.specularRatioInput);
        specularPanel.add(new JLabel(I18n.tr("vmm.core3D.LightSettingsDialog.Exponent"), 4));
        this.specularExponentParam = new IntegerParam("vmm.core3D.LightSettingsDialog.SpecularExponent", this.currentSettings.getSpecularExponent());
        this.specularExponentParam.setDefaultValue(defaultSettings.getSpecularExponent());
        this.specularExponentParam.setMinimumValueForInput(1);
        this.specularExponentParam.setMaximumValueForInput(250);
        this.specularExponentInput = new ParameterInput(this.specularExponentParam);
        this.specularExponentInput.setColumns(7);
        specularPanel.add(this.specularExponentInput);
        this.defaultSettingsButton[0] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.preset.Defaults"));
        this.defaultSettingsButton[1] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.preset.White"));
        this.defaultSettingsButton[2] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.preset.DistinctlyColoredSidesDefault"));
        this.defaultSettingsButton[3] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.preset.HighSpecularityDefault"));
        for (i = 0; i < this.defaultSettingsButton.length; ++i) {
            this.defaultSettingsButton[i].addActionListener(this.defaultsListener);
            defaultsPanel.add(this.defaultSettingsButton[i]);
        }
        this.addInputPanel(panel);
    }

    private JPanel borderedPanel(String title, int rows, int cols) {
        JPanel panel = this.borderedPanel(title);
        panel.setLayout(new GridLayout(rows, cols, 7, 4));
        return panel;
    }

    private double colorComponent(LightSettings lights, int colorNum, int componentNum) {
        Color c;
        switch (colorNum) {
            case 0: {
                c = lights.getLight0();
                break;
            }
            case 1: {
                c = lights.getDirectionalLight1().getItsColor();
                break;
            }
            case 2: {
                c = lights.getDirectionalLight2().getItsColor();
                break;
            }
            case 3: {
                c = lights.getDirectionalLight3().getItsColor();
                break;
            }
            default: {
                c = lights.getAmbientLight();
            }
        }
        switch (componentNum) {
            case 0: {
                return (double)c.getRed() / 255.0;
            }
            case 1: {
                return (double)c.getGreen() / 255.0;
            }
        }
        return (double)c.getBlue() / 255.0;
    }

    @Override
    protected boolean doOK() {
        String error;
        int j;
        int i;
        Vector3D[] directionVectors = new Vector3D[3];
        Color[] colors = new Color[5];
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 3; ++j) {
                error = this.colorInputs[i][j].checkContents();
                if (error != null) {
                    this.errorMessage(error);
                    return false;
                }
                this.colorInputs[i][j].setValueFromContents();
            }
            colors[i] = new Color((float)this.colorParams[i][0].getValue(), (float)this.colorParams[i][1].getValue(), (float)this.colorParams[i][2].getValue());
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                error = this.directionInputs[i][j].checkContents();
                if (error != null) {
                    this.errorMessage(error);
                    return false;
                }
                this.directionInputs[i][j].setValueFromContents();
            }
            directionVectors[i] = new Vector3D(this.directionParams[i][0].getValue(), this.directionParams[i][1].getValue(), this.directionParams[i][2].getValue());
            if (directionVectors[i].norm() < 1.0E-10) {
                this.errorMessage(I18n.tr("vmm.core3D.LightSettingsDialog.BadDirectionVector"));
                this.directionInputs[i][0].requestFocus();
                this.directionInputs[i][0].selectAll();
                return false;
            }
            directionVectors[i].normalize();
        }
        String error2 = this.specularRatioInput.checkContents();
        if (error2 != null) {
            this.errorMessage(error2);
            return false;
        }
        this.specularRatioInput.setValueFromContents();
        error2 = this.specularExponentInput.checkContents();
        if (error2 != null) {
            this.errorMessage(error2);
            return false;
        }
        this.specularExponentInput.setValueFromContents();
        this.currentSettings.setLight0(colors[0]);
        this.currentSettings.setDirectionalLight1(new DirectionalLight(colors[1], directionVectors[0]));
        this.currentSettings.setDirectionalLight2(new DirectionalLight(colors[2], directionVectors[1]));
        this.currentSettings.setDirectionalLight3(new DirectionalLight(colors[3], directionVectors[2]));
        this.currentSettings.setAmbientLight(colors[4]);
        this.currentSettings.setSpecularExponent(this.specularExponentParam.getValue());
        this.currentSettings.setSpecularRatio((float)this.specularRatioParam.getValue());
        this.owner.setLightingEnabled(true);
        this.owner.forceRedraw();
        return true;
    }

    private void errorMessage(String error) {
        JOptionPane.showMessageDialog(this, error, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
    }
}

