/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import vmm.core.Display;
import vmm.core.MouseTask;
import vmm.core.View;

public abstract class TwoPointInput
extends MouseTask {
    public static final int DRAW_NOTHING = 0;
    public static final int DRAW_LINE = 1;
    public static final int DRAW_CIRCLE_FROM_RADIUS = 2;
    public static final int DRAW_CIRCLE_FROM_DIAMETER = 3;
    public static final int DRAW_RECT = 4;
    private int minimumDrag = 2;
    private double maximumDrag = 2.147483647E9;
    private boolean allowOutOfBoundsDrag = true;
    private int figureToDraw = 1;
    private Color drawColor = null;
    private int startX;
    private int endX;
    private int startY;
    private int endY;

    protected abstract void gotPoints(Display var1, View var2, int var3, int var4, int var5, int var6);

    public boolean getAllowOutOfBoundsDrag() {
        return this.allowOutOfBoundsDrag;
    }

    public void setAllowOutOfBoundsDrag(boolean allowOutOfBoundsDrag) {
        this.allowOutOfBoundsDrag = allowOutOfBoundsDrag;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public int getFigureToDraw() {
        return this.figureToDraw;
    }

    public void setFigureToDraw(int figureToDraw) {
        if (figureToDraw == 0 || figureToDraw == 1 || figureToDraw == 3 || figureToDraw == 2 || figureToDraw == 4) {
            this.figureToDraw = figureToDraw;
        }
    }

    public int getMaximumDrag() {
        return (int)this.maximumDrag;
    }

    public void setMaximumDrag(int maximumDrag) {
        this.maximumDrag = maximumDrag;
    }

    public int getMinimumDrag() {
        return this.minimumDrag;
    }

    public void setMinimumDrag(int minimumDrag) {
        this.minimumDrag = minimumDrag;
    }

    @Override
    public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
        this.startX = this.endX = evt.getX();
        this.startY = this.endY = evt.getY();
        return true;
    }

    @Override
    public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
        this.endX = evt.getX();
        this.endY = evt.getY();
        display.repaint();
    }

    @Override
    public void doMouseUp(MouseEvent evt, Display display, View view, int width, int height) {
        int dragDistSquared = (this.startX - this.endX) * (this.startX - this.endX) + (this.startY - this.endY) * (this.startY - this.endY);
        if (dragDistSquared < this.minimumDrag * this.minimumDrag || (double)dragDistSquared > this.maximumDrag * this.maximumDrag) {
            return;
        }
        if (!(this.allowOutOfBoundsDrag || this.endX >= 0 && this.endY >= 0 && this.endX < width && this.endY < height)) {
            return;
        }
        this.gotPoints(display, view, this.startX, this.startY, this.endX, this.endY);
    }

    @Override
    public void drawWhileDragging(Graphics2D g, Display display, View view, int width, int height) {
        if (this.figureToDraw == 0) {
            return;
        }
        int dragDistSquared = (this.startX - this.endX) * (this.startX - this.endX) + (this.startY - this.endY) * (this.startY - this.endY);
        if (dragDistSquared < this.minimumDrag * this.minimumDrag || (double)dragDistSquared > this.maximumDrag * this.maximumDrag) {
            return;
        }
        if (!(this.allowOutOfBoundsDrag || this.endX >= 0 && this.endY >= 0 && this.endX < width && this.endY < height)) {
            return;
        }
        if (this.drawColor != null) {
            g.setColor(this.drawColor);
        }
        switch (this.figureToDraw) {
            case 1: {
                g.drawLine(this.startX, this.startY, this.endX, this.endY);
                break;
            }
            case 3: {
                int diameter = (int)(0.5 * Math.sqrt(dragDistSquared));
                int centerX = (this.endX + this.startX) / 2;
                int centerY = (this.endY + this.startY) / 2;
                g.drawOval(centerX - diameter / 2, centerY - diameter / 2, diameter, diameter);
                break;
            }
            case 2: {
                int radius = (int)(0.5 + Math.sqrt(dragDistSquared));
                g.drawOval(this.startX - radius, this.startY - radius, 2 * radius, 2 * radius);
                break;
            }
            case 4: {
                int x1 = Math.min(this.startX, this.endX);
                int x2 = Math.max(this.startX, this.endX);
                int y1 = Math.min(this.startY, this.endY);
                int y2 = Math.max(this.startY, this.endY);
                g.drawRect(x1, y1, x2 - x1, y2 - y1);
            }
        }
        super.drawWhileDragging(g, display, view, width, height);
    }

    @Override
    public Cursor getCursor(Display display, View view) {
        return Cursor.getPredefinedCursor(1);
    }
}

