/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.Animateable;
import vmm.core.RealParam;

public class RealParamAnimateable
extends RealParam
implements Animateable {
    private double animationStart;
    private double animationEnd;
    private double defaultAnimationStart;
    private double defaultAnimationEnd;
    private String animationStartString;
    private String animationEndString;
    private String defaultStartString;
    private String defaultEndString;

    public RealParamAnimateable() {
        this((String)null, 0.0);
    }

    public RealParamAnimateable(String name, double value) {
        this(name, value, value, value);
    }

    public RealParamAnimateable(String name, double value, double start, double end) {
        super(name, value);
        this.animationStart = this.defaultAnimationStart = start;
        this.animationEnd = this.defaultAnimationEnd = end;
    }

    public RealParamAnimateable(String name, String valueAsString) {
        this(name, valueAsString, valueAsString, valueAsString);
    }

    public RealParamAnimateable(String name, String valueAsString, String startString, String endString) {
        super(name, valueAsString);
        this.setAnimationStartFromString(startString);
        this.setAnimationEndFromString(endString);
        this.setDefaultAnimationStartFromString(startString);
        this.setDefaultAnimationEndFromString(endString);
    }

    @Override
    public void reset(double value) {
        this.reset(new Double(value));
        this.setAnimationLimitsAndDefaults(value, value);
    }

    public void reset(double value, double animationStart, double animationEnd) {
        this.reset(new Double(value));
        this.setAnimationLimitsAndDefaults(animationStart, animationEnd);
    }

    @Override
    public void reset(String valueAsString) {
        this.reset(valueAsString, valueAsString, valueAsString);
    }

    public void reset(String valueAsString, String animationStartAsString, String animationEndAsString) {
        super.reset(valueAsString);
        this.setAnimationStartFromString(animationStartAsString);
        this.setAnimationEndFromString(animationEndAsString);
        this.setDefaultAnimationStartFromString(animationStartAsString);
        this.setDefaultAnimationEndFromString(animationEndAsString);
    }

    public double getDefaultAnimationStart() {
        return this.defaultAnimationStart;
    }

    public double getDefaultAnimationEnd() {
        return this.defaultAnimationEnd;
    }

    public void setDefaultAnimationLimits(double defaultStart, double defaultEnd) {
        this.defaultAnimationStart = defaultStart;
        this.defaultAnimationEnd = defaultEnd;
        this.defaultEndString = null;
        this.defaultStartString = null;
    }

    @Override
    public String getDefaultAnimationStartAsString() {
        return this.defaultStartString != null ? this.defaultStartString : "" + this.defaultAnimationStart;
    }

    @Override
    public String getDefaultAnimationEndAsString() {
        return this.defaultEndString != null ? this.defaultEndString : "" + this.defaultAnimationEnd;
    }

    @Override
    public void setDefaultAnimationStartFromString(String startString) {
        Double d = (Double)this.stringToValueObject(startString);
        this.defaultAnimationStart = d;
        this.defaultStartString = startString;
    }

    @Override
    public void setDefaultAnimationEndFromString(String endString) {
        Double d = (Double)this.stringToValueObject(endString);
        this.defaultAnimationEnd = d;
        this.defaultEndString = endString;
    }

    public void setAnimationLimits(double start, double end) {
        this.animationStart = start;
        this.animationEnd = end;
    }

    public void setAnimationLimitsAndDefaults(double start, double end) {
        this.setAnimationLimits(start, end);
        this.setDefaultAnimationLimits(start, end);
    }

    public void setAnimationStart(double x) {
        this.animationStart = x;
        this.animationStartString = null;
    }

    public void setAnimationEnd(double x) {
        this.animationEnd = x;
        this.animationEndString = null;
    }

    public double getAnimationStart() {
        return this.animationStart;
    }

    public double getAnimationEnd() {
        return this.animationEnd;
    }

    @Override
    public void setAnimationStartFromString(String startVal) {
        Double d = (Double)this.stringToValueObject(startVal);
        this.animationStart = d;
        this.animationStartString = startVal;
    }

    @Override
    public void setAnimationEndFromString(String endVal) {
        Double d = (Double)this.stringToValueObject(endVal);
        this.animationEnd = d;
        this.animationEndString = endVal;
    }

    @Override
    public String getAnimationStartAsString() {
        return this.animationStartString != null ? this.animationStartString : "" + this.animationStart;
    }

    @Override
    public String getAnimationEndAsString() {
        return this.animationEndString != null ? this.animationEndString : "" + this.animationEnd;
    }

    @Override
    public void setFractionComplete(double fractionComplete) {
        this.setValue(this.animationStart + fractionComplete * (this.animationEnd - this.animationStart));
    }

    @Override
    public boolean reallyAnimated() {
        return this.animationStart != this.animationEnd;
    }
}

