/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

public class Complex {
    public static final Complex ZERO_C = new Complex(0.0, 0.0);
    public static final Complex ONE_C = new Complex(1.0, 0.0);
    public static final Complex I_C = new Complex(0.0, 1.0);
    public double re;
    public double im;

    public Complex() {
    }

    public Complex(double x) {
        this.re = x;
    }

    public Complex(double x, double y) {
        this.re = x;
        this.im = y;
    }

    public Complex(Complex c) {
        if (c != null) {
            this.re = c.re;
            this.im = c.im;
        }
    }

    public boolean equals(Object obj) {
        try {
            Complex c = (Complex)obj;
            return c.re == this.re && c.im == this.im;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Complex conj() {
        return new Complex(this.re, -this.im);
    }

    public static Complex polar(double r, double theta) {
        return new Complex(r * Math.cos(theta), r * Math.sin(theta));
    }

    public Complex plus(Complex c) {
        return new Complex(this.re + c.re, this.im + c.im);
    }

    public Complex minus(Complex c) {
        return new Complex(this.re - c.re, this.im - c.im);
    }

    public Complex times(Complex c) {
        return new Complex(this.re * c.re - this.im * c.im, this.re * c.im + this.im * c.re);
    }

    public Complex dividedBy(Complex c) {
        double denom = c.re * c.re + c.im * c.im;
        if (denom == 0.0) {
            return new Complex(Double.NaN, Double.NaN);
        }
        return new Complex((this.re * c.re + this.im * c.im) / denom, (this.im * c.re - this.re * c.im) / denom);
    }

    public Complex times(double x) {
        return new Complex(this.re * x, this.im * x);
    }

    public Complex plus(double x) {
        return new Complex(this.re + x, this.im);
    }

    public Complex minus(double x) {
        return new Complex(this.re - x, this.im);
    }

    public Complex dividedBy(double x) {
        return new Complex(this.re / x, this.im / x);
    }

    public Complex realLinComb(double a, double b, Complex c) {
        return new Complex(a * this.re + b * c.re, a * this.im + b * c.im);
    }

    public Complex complexLinComb(Complex a, Complex b, Complex c) {
        return new Complex(this.times(a).plus(c.times(b)));
    }

    public double dot(Complex c) {
        return this.re * c.re + this.im * c.im;
    }

    public double abs2() {
        return this.re * this.re + this.im * this.im;
    }

    public double r() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public double theta() {
        return Math.atan2(this.im, this.re);
    }

    public Complex exponential() {
        double length = Math.exp(this.re);
        return new Complex(length * Math.cos(this.im), length * Math.sin(this.im));
    }

    public Complex inverse() {
        double length = this.re * this.re + this.im * this.im;
        Complex result = length == 0.0 ? new Complex(Double.NaN, Double.NaN) : new Complex(this.re / length, -this.im / length);
        return result;
    }

    public Complex log() {
        double modulus = Math.sqrt(this.re * this.re + this.im * this.im);
        double arg = Math.atan2(this.im, this.re);
        return new Complex(Math.log(modulus), arg);
    }

    public Complex logNearer(Complex previous) {
        Complex c = new Complex(this.log());
        double h = (c.im - previous.im) / (Math.PI * 2);
        double d = Math.PI * 2 * Math.floor(h + 0.5);
        c.im -= d;
        return c;
    }

    public double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public Complex sine() {
        Complex z = new Complex(0.0, 0.0);
        double x = this.re;
        double y = this.im;
        z.re = Math.sin(x) * this.cosh(y);
        z.im = Math.cos(x) * this.sinh(y);
        return z;
    }

    public Complex power(double x) {
        double modulus = Math.sqrt(this.re * this.re + this.im * this.im);
        double arg = Math.atan2(this.im, this.re);
        double log_re = Math.log(modulus);
        double log_im = arg;
        double x_log_re = x * log_re;
        double x_log_im = x * log_im;
        double modulus_ans = Math.exp(x_log_re);
        return new Complex(modulus_ans * Math.cos(x_log_im), modulus_ans * Math.sin(x_log_im));
    }

    public Complex integerPower(int k) {
        double b;
        double a;
        boolean neg = false;
        if (k < 0) {
            k = -k;
            neg = true;
        }
        if (k == 0) {
            a = 1.0;
            b = 0.0;
        } else if (k == 1) {
            a = this.re;
            b = this.im;
        } else if (k == 2) {
            a = this.re * this.re - this.im * this.im;
            b = 2.0 * this.re * this.im;
        } else if (k == 3) {
            double aux = this.re * this.re - this.im * this.im;
            double bux = 2.0 * this.re * this.im;
            a = this.re * aux - this.im * bux;
            b = this.re * bux + this.im * aux;
        } else if (k == 4) {
            double aux = this.re * this.re - this.im * this.im;
            double bux = 2.0 * this.re * this.im;
            a = aux * aux - bux * bux;
            b = 2.0 * aux * bux;
        } else if (k == 5) {
            double aux = this.re * this.re - this.im * this.im;
            double bux = 2.0 * this.re * this.im;
            double auy = aux * aux - bux * bux;
            double buy = 2.0 * aux * bux;
            a = this.re * auy - this.im * buy;
            b = this.re * buy + this.im * auy;
        } else if (k == 6) {
            double aux = this.re * this.re - this.im * this.im;
            double bux = 2.0 * this.re * this.im;
            double auy = aux * aux - bux * bux;
            double buy = 2.0 * aux * bux;
            a = aux * auy - bux * buy;
            b = aux * buy + bux * auy;
        } else if (k == 7) {
            double aux = this.re * this.re - this.im * this.im;
            double bux = 2.0 * this.re * this.im;
            a = aux * aux - bux * bux;
            b = 2.0 * aux * bux;
            double auy = aux * a - bux * b;
            double buy = aux * b + bux * a;
            a = auy * this.re - buy * this.im;
            b = auy * this.im + buy * this.re;
        } else if (k == 8) {
            double aux = this.re * this.re - this.im * this.im;
            double bux = 2.0 * this.re * this.im;
            double auy = aux * aux - bux * bux;
            double buy = 2.0 * aux * bux;
            a = auy * auy - buy * buy;
            b = 2.0 * auy * buy;
        } else if (k == 9) {
            double aux = this.re * this.re - this.im * this.im;
            double bux = 2.0 * this.re * this.im;
            double auy = aux * aux - bux * bux;
            double buy = 2.0 * aux * bux;
            aux = auy * auy - buy * buy;
            bux = 2.0 * auy * buy;
            a = this.re * aux - this.im * bux;
            b = this.re * bux + this.im * aux;
        } else if (k == 10) {
            double aux = this.re * this.re - this.im * this.im;
            double bux = 2.0 * this.re * this.im;
            double auy = aux * aux - bux * bux;
            double buy = 2.0 * aux * bux;
            aux = this.re * auy - this.im * buy;
            bux = this.re * buy + this.im * auy;
            a = aux * aux - bux * bux;
            b = 2.0 * aux * bux;
        } else {
            double length = this.r();
            double angle = this.theta();
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            length = Math.pow(length, k);
            a = length * Math.cos(angle *= (double)k);
            b = length * Math.sin(angle);
        }
        if (neg) {
            double denom = a * a + b * b;
            if (denom == 0.0) {
                a = Double.NaN;
                b = Double.NaN;
            } else {
                a /= denom;
                b = -b / denom;
            }
        }
        return new Complex(a, b);
    }

    public Complex integerRoot(int k) {
        double b;
        double a;
        boolean neg = false;
        if (k < 0) {
            k = -k;
            neg = true;
        }
        if (k == 0) {
            a = 1.0;
            b = 0.0;
        } else if (k == 1) {
            a = this.re;
            b = this.im;
        } else {
            double length = this.r();
            double angle = this.theta();
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            length = Math.pow(length, 1.0 / (double)k);
            a = length * Math.cos(angle /= (double)k);
            b = length * Math.sin(angle);
        }
        if (neg) {
            double denom = a * a + b * b;
            if (denom == 0.0) {
                a = Double.NaN;
                b = Double.NaN;
            } else {
                a /= denom;
                b = -b / denom;
            }
        }
        return new Complex(a, b);
    }

    public Complex squareRootNearer(Complex previous) {
        Complex c = this.integerRoot(2);
        if (c.re * previous.re + c.im * previous.im < 0.0) {
            c.re = -c.re;
            c.im = -c.im;
        }
        return new Complex(c.re, c.im);
    }

    public Complex mobius1_1(double r) {
        Complex wd = this.times(r);
        Complex wn = wd.plus(this);
        wd.re = wd.re + 1.0 + r;
        wn.re += r;
        return wn.dividedBy(wd);
    }

    public double[] stereographicProjection() {
        double[] projPoint = new double[3];
        double rsquare = this.re * this.re + this.im * this.im;
        double rsquarePlusOne = rsquare + 1.0;
        projPoint[0] = 2.0 * this.re / rsquarePlusOne;
        projPoint[1] = 2.0 * this.im / rsquarePlusOne;
        projPoint[2] = (rsquare - 1.0) / rsquarePlusOne;
        return projPoint;
    }

    public void assign(double x, double y) {
        this.re = x;
        this.im = y;
    }

    public String toString() {
        if (Double.isNaN(this.re) || Double.isNaN(this.im) || Double.isInfinite(this.re) || Double.isInfinite(this.im)) {
            String reStr;
            String string = Double.isNaN(this.re) ? "NaN" : (this.re == Double.POSITIVE_INFINITY ? "+INF" : (reStr = this.re == Double.NEGATIVE_INFINITY ? "-INF" : "" + this.re));
            String imStr = Double.isNaN(this.im) ? "NaN" : (this.im == Double.POSITIVE_INFINITY ? "+INF" : (this.im == Double.NEGATIVE_INFINITY ? "-INF" : "" + this.im));
            return "(" + reStr + ") + i*(" + imStr + ")";
        }
        if (this.im == 0.0) {
            return "" + this.re;
        }
        if (this.im < 0.0) {
            if (this.re == 0.0) {
                return this.im == -1.0 ? "-i" : "-i*" + -this.im;
            }
            return this.re + (this.im == -1.0 ? " - i" : " - i*" + -this.im);
        }
        if (this.re == 0.0) {
            return this.im == 1.0 ? "i" : "i*" + this.im;
        }
        return this.re + (this.im == 1.0 ? " + i" : " + i*" + this.im);
    }

    public void assign(Complex c) {
        this.re = c.re;
        this.im = c.im;
    }

    public double det(Complex c) {
        return this.re * c.im - this.im * c.re;
    }

    public void assignTimes(double d) {
        this.re *= d;
        this.im *= d;
    }

    public void assignInvert() {
        double length = this.re * this.re + this.im * this.im;
        this.re /= length;
        this.im = -this.im / length;
    }

    public void assignPow(Complex z, double x) {
        double modulus = Math.sqrt(z.re * z.re + z.im * z.im);
        double arg = Math.atan2(z.im, z.re);
        double log_re = Math.log(modulus);
        double log_im = arg;
        double x_log_re = x * log_re;
        double x_log_im = x * log_im;
        double modulus_ans = Math.exp(x_log_re);
        this.re = modulus_ans * Math.cos(x_log_im);
        this.im = modulus_ans * Math.sin(x_log_im);
    }

    public void assignPlus(Complex a, Complex b) {
        this.re = a.re + b.re;
        this.im = a.im + b.im;
    }

    public void assignPlus(Complex c) {
        this.re += c.re;
        this.im += c.im;
    }

    public void assignMinus(Complex c) {
        this.re += -c.re;
        this.im += -c.im;
    }

    public void assignTimes(Complex c, double d) {
        this.re = c.re * d;
        this.im = c.im * d;
    }

    public void assignTimes(Complex c) {
        double new_re = this.re * c.re - this.im * c.im;
        this.im = this.re * c.im + this.im * c.re;
        this.re = new_re;
    }

    public void assignTimes(Complex a, Complex b) {
        this.re = a.re * b.re - a.im * b.im;
        this.im = a.re * b.im + a.im * b.re;
    }

    public void assignDivide(Complex c) {
        double denom = c.re * c.re + c.im * c.im;
        double new_re = (this.re * c.re + this.im * c.im) / denom;
        this.im = (this.im * c.re - this.re * c.im) / denom;
        this.re = new_re;
    }

    public void assignTimesTimes(Complex a, double d) {
        this.assignTimes(a);
        this.assignTimes(d);
    }

    public void assignPlusTimes(Complex a, Complex b) {
        this.assignPlus(a);
        this.assignTimes(b);
    }

    public void assignTimesPlus(Complex a, Complex b) {
        this.assignTimes(a);
        this.assignPlus(b);
    }

    public void assign_PlusTimes(Complex a, Complex b) {
        this.re += a.re * b.re - a.im * b.im;
        this.im += a.re * b.im + a.im * b.re;
    }

    public void assign_PlusTimes(Complex a, double d) {
        this.re += a.re * d;
        this.im += a.im * d;
    }

    public void assignTimes_PlusTimes(Complex a, Complex b, double d) {
        this.assignTimes(a);
        this.re += b.re * d;
        this.im += b.im * d;
    }

    public Complex invert() {
        return this.inverse();
    }
}

