/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Propget
extends SvnCommand {
    private File path;
    private SVNUrl url;
    private String name;
    private String property;
    private File file;

    public void execute() throws SvnAntException {
        ISVNProperty iSVNProperty;
        try {
            iSVNProperty = this.path != null ? this.svnClient.propertyGet(this.path, this.name) : this.svnClient.propertyGet(this.url, this.name);
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Can't get property " + this.name, sVNClientException);
        }
        if (this.property != null && iSVNProperty != null) {
            this.getProject().setProperty(this.property, iSVNProperty.getValue());
        }
        if (this.file != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.file);
                if (iSVNProperty != null) {
                    fileOutputStream.write(iSVNProperty.getData());
                }
            }
            catch (IOException iOException) {
                throw new SvnAntException("Can't write property value to file " + this.file.toString(), iOException);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.path == null && this.url == null || this.path != null && this.url != null) {
            throw new SvnAntValidationException("path attribute or url attribute must be set");
        }
        if (this.name == null) {
            throw new SvnAntValidationException("svnPropertyName attribute must be set");
        }
        if (this.property == null && this.file == null) {
            throw new SvnAntValidationException("property or file attribute must be set");
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setName(String string) {
        this.name = string;
    }
}

