/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml.css;

import java.util.HashMap;
import java.util.Map;
import net.n3.nanoxml.IXMLElement;
import org.w3c.dom.Element;

public class CSSRule {
    private String selector;
    private SelectorType type;
    protected Map<String, String> properties;

    public CSSRule(String name, String value) {
        this.properties = new HashMap<String, String>();
        this.properties.put(name, value);
    }

    public CSSRule(String selector, String propertyName, String propertyValue) {
        this.setSelector(selector);
        this.properties = new HashMap<String, String>();
        this.properties.put(propertyName, propertyValue);
    }

    public CSSRule(String selector, Map<String, String> properties) {
        this.setSelector(selector);
        this.properties = properties;
    }

    public void setSelector(String selector) {
        switch (selector.charAt(0)) {
            case '*': {
                this.type = SelectorType.ALL;
                break;
            }
            case '.': {
                this.type = SelectorType.CLASS_ATTRIBUTE;
                break;
            }
            case '#': {
                this.type = SelectorType.ID_ATTRIBUTE;
                break;
            }
            default: {
                this.type = SelectorType.ELEMENT_NAME;
            }
        }
        this.selector = this.type == SelectorType.ELEMENT_NAME ? selector : selector.substring(1);
    }

    public boolean matches(Element elem) {
        boolean isMatch = false;
        block0 : switch (this.type) {
            case ALL: {
                isMatch = true;
                break;
            }
            case ELEMENT_NAME: {
                String name = elem.getLocalName();
                isMatch = name.equals(this.selector);
                break;
            }
            case CLASS_ATTRIBUTE: {
                String[] clazzes;
                String value = elem.getAttribute("class");
                if (value == null) break;
                for (String clazz : clazzes = value.split(" ")) {
                    if (!clazz.equals(this.selector)) continue;
                    isMatch = true;
                    break block0;
                }
                break;
            }
            case ID_ATTRIBUTE: {
                String name = elem.getAttribute("id");
                isMatch = name != null && name.equals(this.selector);
                break;
            }
        }
        return isMatch;
    }

    public boolean matches(IXMLElement elem) {
        boolean isMatch = false;
        block0 : switch (this.type) {
            case ALL: {
                isMatch = true;
                break;
            }
            case ELEMENT_NAME: {
                String name = elem.getName();
                isMatch = name != null && name.equals(this.selector);
                break;
            }
            case CLASS_ATTRIBUTE: {
                String[] clazzes;
                String value = elem.getAttribute("class", null);
                if (value == null) break;
                for (String clazz : clazzes = value.split(" ")) {
                    if (!clazz.equals(this.selector)) continue;
                    isMatch = true;
                    break block0;
                }
                break;
            }
            case ID_ATTRIBUTE: {
                String name = elem.getAttribute("id", null);
                isMatch = name != null && name.equals(this.selector);
                break;
            }
        }
        return isMatch;
    }

    public void apply(Element elem) {
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            if (elem.hasAttribute(property.getKey())) continue;
            elem.setAttribute(property.getKey(), property.getValue());
        }
    }

    public void apply(IXMLElement elem) {
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            if (elem.hasAttribute(property.getKey())) continue;
            elem.setAttribute(property.getKey(), property.getValue());
        }
    }

    public String toString() {
        return "CSSRule[" + this.selector + this.properties + "]";
    }

    private static enum SelectorType {
        ALL,
        ELEMENT_NAME,
        CLASS_ATTRIBUTE,
        ID_ATTRIBUTE;

    }
}

