/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.regex.Matcher;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class JavaPrimitivesDOMFactory
implements DOMFactory {
    private String escape(String name) {
        name = name.replaceAll("\\$", "..");
        return name;
    }

    private String unescape(String name) {
        name = name.replaceAll("\\.\\.", Matcher.quoteReplacement("$"));
        return name;
    }

    @Override
    public String getName(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Boolean) {
            return "boolean";
        }
        if (o instanceof Byte) {
            return "byte";
        }
        if (o instanceof Character) {
            return "char";
        }
        if (o instanceof Short) {
            return "short";
        }
        if (o instanceof Integer) {
            return "int";
        }
        if (o instanceof Long) {
            return "long";
        }
        if (o instanceof Float) {
            return "float";
        }
        if (o instanceof Double) {
            return "double";
        }
        if (o instanceof Color) {
            return "color";
        }
        if (o instanceof Font) {
            return "font";
        }
        if (o instanceof byte[]) {
            return "byteArray";
        }
        if (o instanceof char[]) {
            return "charArray";
        }
        if (o instanceof short[]) {
            return "shortArray";
        }
        if (o instanceof int[]) {
            return "intArray";
        }
        if (o instanceof long[]) {
            return "longArray";
        }
        if (o instanceof float[]) {
            return "floatArray";
        }
        if (o instanceof double[]) {
            return "doubleArray";
        }
        if (o instanceof String) {
            return "string";
        }
        if (o instanceof Enum) {
            return "enum";
        }
        if (o instanceof Color) {
            return "color";
        }
        if (o instanceof Font) {
            return "font";
        }
        return this.escape(o.getClass().getName());
    }

    @Override
    public Object create(String name) {
        name = this.unescape(name);
        try {
            return Class.forName(name).newInstance();
        }
        catch (InstantiationException ex) {
            IllegalArgumentException e = new IllegalArgumentException("Class " + name + " can not instantiate an object");
            e.initCause(ex);
            throw e;
        }
        catch (IllegalAccessException ex) {
            IllegalArgumentException e = new IllegalArgumentException("Class " + name + " is not public");
            e.initCause(ex);
            throw e;
        }
        catch (ClassNotFoundException ex) {
            IllegalArgumentException e = new IllegalArgumentException("Class " + name + " does not exist");
            e.initCause(ex);
            throw e;
        }
    }

    protected String getEnumName(Enum o) {
        return this.escape(o.getClass().getName());
    }

    protected String getEnumValue(Enum o) {
        return o.name();
    }

    protected Enum createEnum(String name, String value) {
        Class<?> enumClass;
        name = this.unescape(name);
        try {
            enumClass = Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class not found for Enum with name:" + name);
        }
        if (enumClass == null) {
            throw new IllegalArgumentException("Enum name not known to factory:" + name);
        }
        return Enum.valueOf(enumClass, value);
    }

    @Override
    public void write(DOMOutput out, Object o) throws IOException {
        if (o != null) {
            if (o instanceof DOMStorable) {
                ((DOMStorable)o).write(out);
            } else if (o instanceof String) {
                out.addText((String)o);
            } else if (o instanceof Integer) {
                out.addText(o.toString());
            } else if (o instanceof Long) {
                out.addText(o.toString());
            } else if (o instanceof Double) {
                out.addText(o.toString());
            } else if (o instanceof Float) {
                out.addText(o.toString());
            } else if (o instanceof Boolean) {
                out.addText(o.toString());
            } else if (o instanceof Color) {
                Color c = (Color)o;
                out.addAttribute("rgba", "#" + Integer.toHexString(c.getRGB()));
            } else if (o instanceof byte[]) {
                byte[] a = (byte[])o;
                for (int i = 0; i < a.length; ++i) {
                    out.openElement("byte");
                    this.write(out, a[i]);
                    out.closeElement();
                }
            } else if (o instanceof boolean[]) {
                boolean[] a = (boolean[])o;
                for (int i = 0; i < a.length; ++i) {
                    out.openElement("boolean");
                    this.write(out, a[i]);
                    out.closeElement();
                }
            } else if (o instanceof char[]) {
                char[] a = (char[])o;
                for (int i = 0; i < a.length; ++i) {
                    out.openElement("char");
                    this.write(out, Character.valueOf(a[i]));
                    out.closeElement();
                }
            } else if (o instanceof short[]) {
                short[] a = (short[])o;
                for (int i = 0; i < a.length; ++i) {
                    out.openElement("short");
                    this.write(out, a[i]);
                    out.closeElement();
                }
            } else if (o instanceof int[]) {
                int[] a = (int[])o;
                for (int i = 0; i < a.length; ++i) {
                    out.openElement("int");
                    this.write(out, a[i]);
                    out.closeElement();
                }
            } else if (o instanceof long[]) {
                long[] a = (long[])o;
                for (int i = 0; i < a.length; ++i) {
                    out.openElement("long");
                    this.write(out, a[i]);
                    out.closeElement();
                }
            } else if (o instanceof float[]) {
                float[] a = (float[])o;
                for (int i = 0; i < a.length; ++i) {
                    out.openElement("float");
                    this.write(out, Float.valueOf(a[i]));
                    out.closeElement();
                }
            } else if (o instanceof double[]) {
                double[] a = (double[])o;
                for (int i = 0; i < a.length; ++i) {
                    out.openElement("double");
                    this.write(out, a[i]);
                    out.closeElement();
                }
            } else if (o instanceof Font) {
                Font f = (Font)o;
                out.addAttribute("name", f.getName());
                out.addAttribute("style", f.getStyle());
                out.addAttribute("size", f.getSize());
            } else if (o instanceof Enum) {
                Enum e = (Enum)o;
                out.addAttribute("type", this.getEnumName(e));
                out.addText(this.getEnumValue(e));
            } else {
                throw new IllegalArgumentException("Unsupported object type:" + o);
            }
        }
    }

    @Override
    @Nullable
    public Object read(DOMInput in) throws IOException {
        Object o;
        String tagName = in.getTagName();
        if (tagName.equals("null")) {
            o = null;
        } else if (tagName.equals("boolean")) {
            o = Boolean.valueOf(in.getText());
        } else if (tagName.equals("byte")) {
            o = Byte.decode(in.getText());
        } else if (tagName.equals("short")) {
            o = Short.decode(in.getText());
        } else if (tagName.equals("int")) {
            o = Integer.decode(in.getText());
        } else if (tagName.equals("long")) {
            o = Long.decode(in.getText());
        } else if (tagName.equals("float")) {
            o = new Float(Float.parseFloat(in.getText()));
        } else if (tagName.equals("double")) {
            o = new Double(Double.parseDouble(in.getText()));
        } else if (tagName.equals("string")) {
            o = in.getText();
        } else if (tagName.equals("enum")) {
            o = this.createEnum(in.getAttribute("type", null), in.getText());
        } else if (tagName.equals("color")) {
            o = new Color(in.getAttribute("rgba", 255));
        } else if (tagName.equals("font")) {
            o = new Font(in.getAttribute("name", "Dialog"), in.getAttribute("style", 0), in.getAttribute("size", 0));
        } else if (tagName.equals("byteArray")) {
            byte[] a = new byte[in.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Byte)in.readObject(i);
            }
            o = a;
        } else if (tagName.equals("shortArray")) {
            short[] a = new short[in.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Short)in.readObject(i);
            }
            o = a;
        } else if (tagName.equals("intArray")) {
            int[] a = new int[in.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Integer)in.readObject(i);
            }
            o = a;
        } else if (tagName.equals("longArray")) {
            long[] a = new long[in.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Long)in.readObject(i);
            }
            o = a;
        } else if (tagName.equals("floatArray")) {
            float[] a = new float[in.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = ((Float)in.readObject(i)).floatValue();
            }
            o = a;
        } else if (tagName.equals("doubleArray")) {
            double[] a = new double[in.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Double)in.readObject(i);
            }
            o = a;
        } else {
            o = this.create(in.getTagName());
        }
        return o;
    }
}

