/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.text.ParseException;
import org.jhotdraw.color.HSBColorSpace;
import org.jhotdraw.text.ColorFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class ColorToolTipTextFormatter
extends ColorFormatter {
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("/org/jhotdraw.draw.Labels");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String valueToString(Object value) throws ParseException {
        String str = null;
        if (value == null) {
            if (!this.allowsNullValue) throw new ParseException("Null value is not allowed.", 0);
            return "";
        }
        if (!(value instanceof Color)) {
            throw new ParseException("Value is not a color " + value, 0);
        }
        Color c = (Color)value;
        ColorFormatter.Format f = this.outputFormat;
        if (this.isAdaptive) {
            f = c.getColorSpace().equals(HSBColorSpace.getInstance()) ? ColorFormatter.Format.HSB_PERCENTAGE : (c.getColorSpace().equals(ColorSpace.getInstance(1003)) ? ColorFormatter.Format.GRAY_PERCENTAGE : ColorFormatter.Format.RGB_INTEGER);
        }
        switch (f) {
            case RGB_HEX: {
                str = "000000" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
                return this.labels.getFormatted("attribute.color.rgbHexComponents.toolTipText", str.substring(str.length() - 6));
            }
            case RGB_INTEGER: {
                return this.labels.getFormatted("attribute.color.rgbComponents.toolTipText", this.numberFormat.format(c.getRed()), this.numberFormat.format(c.getGreen()), this.numberFormat.format(c.getBlue()));
            }
            case RGB_PERCENTAGE: {
                return this.labels.getFormatted("attribute.color.rgbPercentageComponents.toolTipText", this.numberFormat.format((float)c.getRed() / 255.0f), this.numberFormat.format((float)c.getGreen() / 255.0f), this.numberFormat.format((float)c.getBlue() / 255.0f));
            }
            case HSB_PERCENTAGE: {
                float[] components = c.getColorSpace().equals(HSBColorSpace.getInstance()) ? c.getComponents(null) : Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
                return this.labels.getFormatted("attribute.color.hsbComponents.toolTipText", this.numberFormat.format(components[0] * 360.0f), this.numberFormat.format(components[1] * 100.0f), this.numberFormat.format(components[2] * 100.0f));
            }
            case GRAY_PERCENTAGE: {
                float[] components = c.getColorSpace().equals(ColorSpace.getInstance(1003)) ? c.getComponents(null) : c.getColorComponents(ColorSpace.getInstance(1003), null);
                return this.labels.getFormatted("attribute.color.grayComponents.toolTipText", this.numberFormat.format(components[0] * 100.0f));
            }
        }
        return str;
    }
}

