/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.net.URL;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;

public class SelectionOpacityIcon
extends ImageIcon {
    @Nullable
    private DrawingEditor editor;
    private AttributeKey<Double> opacityKey;
    private AttributeKey<Color> fillColorKey;
    @Nullable
    private AttributeKey<Color> strokeColorKey;
    private Shape fillShape;
    private Shape strokeShape;

    public SelectionOpacityIcon(DrawingEditor editor, AttributeKey<Double> opacityKey, AttributeKey<Color> fillColorKey, @Nullable AttributeKey<Color> strokeColorKey, URL imageLocation, Shape fillShape, Shape strokeShape) {
        super(imageLocation);
        this.editor = editor;
        this.opacityKey = opacityKey;
        this.fillColorKey = fillColorKey;
        this.strokeColorKey = strokeColorKey;
        this.fillShape = fillShape;
        this.strokeShape = strokeShape;
    }

    public SelectionOpacityIcon(DrawingEditor editor, AttributeKey<Double> opacityKey, AttributeKey<Color> fillColorKey, @Nullable AttributeKey<Color> strokeColorKey, Image image, Shape fillShape, Shape strokeShape) {
        super(image);
        this.editor = editor;
        this.opacityKey = opacityKey;
        this.fillColorKey = fillColorKey;
        this.strokeColorKey = strokeColorKey;
        this.fillShape = fillShape;
        this.strokeShape = strokeShape;
    }

    @Override
    public void paintIcon(Component c, Graphics gr, int x, int y) {
        Color strokeColor;
        Color fillColor;
        Double opacity;
        DrawingView view;
        Graphics2D g = (Graphics2D)gr;
        super.paintIcon(c, g, x, y);
        DrawingView drawingView = view = this.editor == null ? null : this.editor.getActiveView();
        if (view != null && view.getSelectedFigures().size() == 1) {
            Figure f = view.getSelectedFigures().iterator().next();
            opacity = f.get(this.opacityKey);
            fillColor = this.fillColorKey == null ? null : f.get(this.fillColorKey);
            strokeColor = this.strokeColorKey == null ? null : f.get(this.strokeColorKey);
        } else if (this.editor != null) {
            opacity = this.opacityKey.get(this.editor.getDefaultAttributes());
            fillColor = this.fillColorKey == null ? null : this.fillColorKey.get(this.editor.getDefaultAttributes());
            strokeColor = this.strokeColorKey == null ? null : this.strokeColorKey.get(this.editor.getDefaultAttributes());
        } else {
            opacity = this.opacityKey.getDefaultValue();
            fillColor = this.fillColorKey == null ? null : this.fillColorKey.getDefaultValue();
            Color color = strokeColor = this.strokeColorKey == null ? null : this.strokeColorKey.getDefaultValue();
        }
        if (this.fillColorKey != null && this.fillShape != null && opacity != null) {
            if (fillColor == null) {
                fillColor = Color.BLACK;
            }
            g.setColor(new Color((int)(opacity * 255.0) << 24 | fillColor.getRGB() & 0xFFFFFF, true));
            g.translate(x, y);
            g.fill(this.fillShape);
            g.translate(-x, -y);
        }
        if (this.strokeColorKey != null && this.strokeShape != null && opacity != null) {
            if (strokeColor == null) {
                strokeColor = Color.BLACK;
            }
            g.setColor(new Color((int)(opacity * 255.0) << 24 | strokeColor.getRGB() & 0xFFFFFF, true));
            g.translate(x, y);
            g.draw(this.strokeShape);
            g.translate(-x, -y);
        }
    }
}

