/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.handle.BoundsOutlineHandle;
import org.jhotdraw.draw.handle.FontSizeHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.draw.handle.TransformHandleKit;
import org.jhotdraw.draw.locator.RelativeLocator;
import org.jhotdraw.draw.tool.TextEditingTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;

public class SVGTextFigure
extends SVGAttributedFigure
implements TextHolderFigure,
SVGFigure {
    protected Point2D.Double[] coordinates = new Point2D.Double[]{new Point2D.Double()};
    protected double[] rotates = new double[]{0.0};
    private boolean editable = true;
    @Nullable
    private transient Shape cachedTextShape;
    @Nullable
    private transient Rectangle2D.Double cachedBounds;
    @Nullable
    private transient Rectangle2D.Double cachedDrawingArea;

    public SVGTextFigure() {
        this("Text");
    }

    public SVGTextFigure(String text) {
        this.setText(text);
        SVGAttributeKeys.setDefaults(this);
        this.setConnectable(false);
    }

    @Override
    protected void drawText(Graphics2D g) {
    }

    @Override
    protected void drawFill(Graphics2D g) {
        g.fill(this.getTextShape());
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        g.draw(this.getTextShape());
    }

    public void setCoordinates(Point2D.Double[] coordinates) {
        this.coordinates = (Point2D.Double[])coordinates.clone();
        this.invalidate();
    }

    public Point2D.Double[] getCoordinates() {
        Point2D.Double[] c = new Point2D.Double[this.coordinates.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (Point2D.Double)this.coordinates[i].clone();
        }
        return c;
    }

    public void setRotates(double[] rotates) {
        this.rotates = (double[])rotates.clone();
        this.invalidate();
    }

    public double[] getRotates() {
        return (double[])this.rotates.clone();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.cachedBounds == null) {
            this.cachedBounds = new Rectangle2D.Double();
            this.cachedBounds.setRect(this.getTextShape().getBounds2D());
            String text = this.getText();
            if (text == null || text.length() == 0) {
                text = " ";
            }
            FontRenderContext frc = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> textAttributes = new HashMap<TextAttribute, Serializable>();
            textAttributes.put(TextAttribute.FONT, this.getFont());
            if (((Boolean)this.get(SVGAttributeKeys.FONT_UNDERLINE)).booleanValue()) {
                textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            TextLayout textLayout = new TextLayout(text, textAttributes, frc);
            this.cachedBounds.setRect(this.coordinates[0].x, this.coordinates[0].y - (double)textLayout.getAscent(), textLayout.getAdvance(), textLayout.getAscent());
            AffineTransform tx = new AffineTransform();
            tx.translate(this.coordinates[0].x, this.coordinates[0].y);
            switch (this.get(SVGAttributeKeys.TEXT_ANCHOR)) {
                case END: {
                    this.cachedBounds.x -= (double)textLayout.getAdvance();
                    break;
                }
                case MIDDLE: {
                    this.cachedBounds.x -= (double)textLayout.getAdvance() / 2.0;
                    break;
                }
            }
            tx.rotate(this.rotates[0]);
        }
        return (Rectangle2D.Double)this.cachedBounds.clone();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D rx = this.getTextShape().getBounds2D();
            Rectangle2D.Double r = rx instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
            double g = SVGAttributeKeys.getPerpendicularHitGrowth(this) + 1.0;
            Geom.grow(r, g, g);
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.cachedDrawingArea = r;
            } else {
                this.cachedDrawingArea = new Rectangle2D.Double();
                this.cachedDrawingArea.setRect(((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(r).getBounds2D());
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                p = (Point2D.Double)((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(p, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        return this.getTextShape().getBounds2D().contains(p);
    }

    private Shape getTextShape() {
        if (this.cachedTextShape == null) {
            String text = this.getText();
            if (text == null || text.length() == 0) {
                text = " ";
            }
            FontRenderContext frc = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> textAttributes = new HashMap<TextAttribute, Serializable>();
            textAttributes.put(TextAttribute.FONT, this.getFont());
            if (((Boolean)this.get(SVGAttributeKeys.FONT_UNDERLINE)).booleanValue()) {
                textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            TextLayout textLayout = new TextLayout(text, textAttributes, frc);
            AffineTransform tx = new AffineTransform();
            tx.translate(this.coordinates[0].x, this.coordinates[0].y);
            switch (this.get(SVGAttributeKeys.TEXT_ANCHOR)) {
                case END: {
                    tx.translate(-textLayout.getAdvance(), 0.0);
                    break;
                }
                case MIDDLE: {
                    tx.translate((double)(-textLayout.getAdvance()) / 2.0, 0.0);
                    break;
                }
            }
            tx.rotate(this.rotates[0]);
            this.cachedTextShape = tx.createTransformedShape(textLayout.getOutline(tx));
            this.cachedTextShape = textLayout.getOutline(tx);
        }
        return this.cachedTextShape;
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.coordinates = new Point2D.Double[]{new Point2D.Double(anchor.x, anchor.y)};
        this.rotates = new double[]{0.0};
    }

    @Override
    public void transform(AffineTransform tx) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || tx.getType() != (tx.getType() & 1)) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.set(SVGAttributeKeys.TRANSFORM, (AffineTransform)tx.clone());
            } else {
                AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                this.set(SVGAttributeKeys.TRANSFORM, t);
            }
        } else {
            for (int i = 0; i < this.coordinates.length; ++i) {
                tx.transform(this.coordinates[i], this.coordinates[i]);
            }
            if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null && !this.get(SVGAttributeKeys.FILL_GRADIENT).isRelativeToFigureBounds()) {
                Gradient g = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                this.set(SVGAttributeKeys.FILL_GRADIENT, g);
            }
            if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null && !this.get(SVGAttributeKeys.STROKE_GRADIENT).isRelativeToFigureBounds()) {
                Gradient g = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                this.set(SVGAttributeKeys.STROKE_GRADIENT, g);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Object[] restoreData = (Object[])geometry;
        SVGAttributeKeys.TRANSFORM.setClone(this, (AffineTransform)restoreData[0]);
        Point2D.Double[] restoredCoordinates = (Point2D.Double[])restoreData[1];
        for (int i = 0; i < this.coordinates.length; ++i) {
            this.coordinates[i] = (Point2D.Double)restoredCoordinates[i].clone();
        }
        SVGAttributeKeys.FILL_GRADIENT.setClone(this, (Gradient)restoreData[2]);
        SVGAttributeKeys.STROKE_GRADIENT.setClone(this, (Gradient)restoreData[3]);
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        Point2D.Double[] restoredCoordinates = (Point2D.Double[])this.coordinates.clone();
        for (int i = 0; i < this.coordinates.length; ++i) {
            restoredCoordinates[i] = (Point2D.Double)this.coordinates[i].clone();
        }
        return new Object[]{SVGAttributeKeys.TRANSFORM.getClone(this), restoredCoordinates, SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public String getText() {
        return (String)this.get(SVGAttributeKeys.TEXT);
    }

    @Override
    public <T> void set(AttributeKey<T> key, T newValue) {
        if (key.equals(SVGAttributeKeys.TRANSFORM) || key.equals(SVGAttributeKeys.FONT_FACE) || key.equals(SVGAttributeKeys.FONT_BOLD) || key.equals(SVGAttributeKeys.FONT_ITALIC) || key.equals(SVGAttributeKeys.FONT_SIZE)) {
            this.invalidate();
        }
        super.set(key, newValue);
    }

    @Override
    public void setText(String newText) {
        this.set(SVGAttributeKeys.TEXT, newText);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    public int getTextColumns() {
        return 4;
    }

    @Override
    public Font getFont() {
        return SVGAttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return (Color)this.get(SVGAttributeKeys.FILL_COLOR);
    }

    @Override
    public Color getFillColor() {
        return this.get(SVGAttributeKeys.FILL_COLOR) == null || ((Color)this.get(SVGAttributeKeys.FILL_COLOR)).equals(Color.white) ? Color.black : Color.WHITE;
    }

    @Override
    public void setFontSize(float size) {
        Point2D.Double p = new Point2D.Double(0.0, size);
        AffineTransform tx = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
        if (tx != null) {
            try {
                tx.inverseTransform(p, p);
                Point2D.Double p0 = new Point2D.Double(0.0, 0.0);
                tx.inverseTransform(p0, p0);
                p.y -= p0.y;
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        this.set(SVGAttributeKeys.FONT_SIZE, Math.abs(p.y));
    }

    @Override
    public float getFontSize() {
        Point2D.Double p = new Point2D.Double(0.0, (Double)this.get(SVGAttributeKeys.FONT_SIZE));
        AffineTransform tx = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
        if (tx != null) {
            tx.transform(p, p);
            Point2D.Double p0 = new Point2D.Double(0.0, 0.0);
            tx.transform(p0, p0);
            p.y -= p0.y;
        }
        return (float)Math.abs(p.y);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedTextShape = null;
        this.cachedBounds = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double b = this.getBounds();
        return new Dimension2DDouble(b.width, b.height);
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case -1: {
                handles.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                handles.add(new BoundsOutlineHandle(this));
                handles.add(new MoveHandle(this, RelativeLocator.northWest()));
                handles.add(new MoveHandle(this, RelativeLocator.northEast()));
                handles.add(new MoveHandle(this, RelativeLocator.southWest()));
                handles.add(new MoveHandle(this, RelativeLocator.southEast()));
                handles.add(new FontSizeHandle(this));
                handles.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
            }
        }
        return handles;
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            TextEditingTool tool = new TextEditingTool(this);
            return tool;
        }
        return null;
    }

    @Override
    public double getBaseline() {
        return this.coordinates[0].y - this.getBounds().y;
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this;
    }

    @Override
    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    @Override
    public SVGTextFigure clone() {
        SVGTextFigure that = (SVGTextFigure)super.clone();
        that.coordinates = new Point2D.Double[this.coordinates.length];
        for (int i = 0; i < this.coordinates.length; ++i) {
            that.coordinates[i] = (Point2D.Double)this.coordinates[i].clone();
        }
        that.rotates = (double[])this.rotates.clone();
        that.cachedBounds = null;
        that.cachedDrawingArea = null;
        that.cachedTextShape = null;
        return that;
    }

    @Override
    public boolean isEmpty() {
        return this.getText() == null || this.getText().length() == 0;
    }

    @Override
    public boolean isTextOverflow() {
        return false;
    }
}

