/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class CombineAction
extends AbstractSelectedAction {
    public static final String ID = "edit.combinePaths";
    private CompositeFigure prototype;
    private boolean isCombineAction;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");

    public CombineAction(DrawingEditor editor) {
        this(editor, new SVGPathFigure(true), true);
    }

    public CombineAction(DrawingEditor editor, SVGPathFigure prototype) {
        this(editor, prototype, true);
    }

    public CombineAction(DrawingEditor editor, SVGPathFigure prototype, boolean isGroupingAction) {
        super(editor);
        this.prototype = prototype;
        this.isCombineAction = isGroupingAction;
        this.labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.labels.configureAction(this, ID);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.isCombineAction ? this.canGroup() : this.canUngroup());
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canGroup() {
        boolean canCombine;
        boolean bl = canCombine = this.getView().getSelectionCount() > 1;
        if (canCombine) {
            for (Figure f : this.getView().getSelectedFigures()) {
                if (f instanceof SVGPathFigure) continue;
                canCombine = false;
                break;
            }
        }
        return canCombine;
    }

    protected boolean canUngroup() {
        return this.getView() != null && this.getView().getSelectionCount() == 1 && this.prototype != null && this.getView().getSelectedFigures().iterator().next().getClass().equals(this.prototype.getClass()) && ((CompositeFigure)this.getView().getSelectedFigures().iterator().next()).getChildCount() > 1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isCombineAction) {
            this.combineActionPerformed(e);
        } else {
            this.splitActionPerformed(e);
        }
    }

    public void combineActionPerformed(ActionEvent e) {
        final DrawingView view = this.getView();
        Drawing drawing = view.getDrawing();
        if (this.canGroup()) {
            final List<Figure> ungroupedPaths = drawing.sort(view.getSelectedFigures());
            final int[] ungroupedPathsIndices = new int[ungroupedPaths.size()];
            final int[] ungroupedPathsChildCounts = new int[ungroupedPaths.size()];
            int i = 0;
            for (Figure f : ungroupedPaths) {
                ungroupedPathsIndices[i] = drawing.indexOf(f);
                ungroupedPathsChildCounts[i] = ((CompositeFigure)f).getChildCount();
                ++i;
            }
            final CompositeFigure group = (CompositeFigure)this.prototype.clone();
            this.combinePaths(view, group, ungroupedPaths, ungroupedPathsIndices[0]);
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return CombineAction.this.labels.getTextProperty(CombineAction.ID);
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    CombineAction.this.combinePaths(view, group, ungroupedPaths, ungroupedPathsIndices[0]);
                }

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    CombineAction.this.splitPath(view, group, ungroupedPaths, ungroupedPathsIndices, ungroupedPathsChildCounts);
                }

                @Override
                public boolean addEdit(UndoableEdit anEdit) {
                    return super.addEdit(anEdit);
                }
            };
            this.fireUndoableEditHappened(edit);
        }
    }

    public void splitActionPerformed(ActionEvent e) {
        final DrawingView view = this.getView();
        Drawing drawing = view.getDrawing();
        if (this.canUngroup()) {
            final CompositeFigure group = (CompositeFigure)view.getSelectedFigures().iterator().next();
            final LinkedList<Figure> ungroupedPaths = new LinkedList<Figure>();
            final int[] ungroupedPathsIndices = new int[group.getChildCount()];
            final int[] ungroupedPathsChildCounts = new int[group.getChildCount()];
            int i = 0;
            int index = drawing.indexOf(group);
            for (Figure f : group.getChildren()) {
                SVGPathFigure path = new SVGPathFigure(true);
                for (Map.Entry<AttributeKey, Object> entry : group.getAttributes().entrySet()) {
                    path.set(entry.getKey(), entry.getValue());
                }
                ungroupedPaths.add(path);
                ungroupedPathsIndices[i] = index + i;
                ungroupedPathsChildCounts[i] = 1;
                ++i;
            }
            this.splitPath(view, group, ungroupedPaths, ungroupedPathsIndices, ungroupedPathsChildCounts);
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return CombineAction.this.labels.getTextProperty("edit.splitPath");
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    CombineAction.this.splitPath(view, group, ungroupedPaths, ungroupedPathsIndices, ungroupedPathsChildCounts);
                }

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    CombineAction.this.combinePaths(view, group, ungroupedPaths, ungroupedPathsIndices[0]);
                }
            };
            this.fireUndoableEditHappened(edit);
        }
    }

    public void splitPath(DrawingView view, CompositeFigure group, List<Figure> ungroupedPaths, int[] ungroupedPathsIndices, int[] ungroupedPathsChildCounts) {
        view.clearSelection();
        Iterator groupedFigures = new LinkedList<Figure>(group.getChildren()).iterator();
        group.basicRemoveAllChildren();
        view.getDrawing().remove(group);
        SVGPathFigure pathFigure = (SVGPathFigure)group;
        pathFigure.flattenTransform();
        for (int i = 0; i < ungroupedPaths.size(); ++i) {
            CompositeFigure path = (CompositeFigure)ungroupedPaths.get(i);
            view.getDrawing().add(ungroupedPathsIndices[i], path);
            path.willChange();
            for (int j = 0; j < ungroupedPathsChildCounts[i]; ++j) {
                Figure child = (Figure)groupedFigures.next();
                child.willChange();
                path.basicAdd(child);
            }
            path.changed();
        }
        view.addToSelection(ungroupedPaths);
    }

    public void combinePaths(DrawingView view, CompositeFigure group, Collection<Figure> figures, int groupIndex) {
        view.getDrawing().basicRemoveAll(figures);
        view.clearSelection();
        view.getDrawing().add(groupIndex, group);
        group.willChange();
        group.basicRemoveAllChildren();
        AffineTransform tx = (AffineTransform)figures.iterator().next().get(SVGAttributeKeys.TRANSFORM);
        for (Figure figure : figures) {
            AffineTransform ftx = (AffineTransform)figure.get(SVGAttributeKeys.TRANSFORM);
            if (ftx == tx || ftx != null && tx != null && ftx.equals(tx)) continue;
            tx = null;
            break;
        }
        for (Map.Entry entry : figures.iterator().next().getAttributes().entrySet()) {
            group.set((AttributeKey)entry.getKey(), entry.getValue());
        }
        group.set(SVGAttributeKeys.TRANSFORM, tx);
        for (Figure figure : figures) {
            SVGPathFigure path = (SVGPathFigure)figure;
            if (tx == null) {
                path.flattenTransform();
            }
            LinkedList<Figure> children = new LinkedList<Figure>(path.getChildren());
            path.basicRemoveAllChildren();
            for (Figure child : children) {
                SVGBezierFigure bez = (SVGBezierFigure)child;
                child.willChange();
                group.basicAdd(child);
            }
        }
        group.changed();
        view.addToSelection(group);
    }
}

